/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.InetSocketAddress;
import org.apache.flink.client.minicluster.NepheleMiniCluster;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterUtil.class);
    public static final String CANNOT_EXECUTE_EMPTY_JOB = "Cannot execute empty job";

    public static void runOnMiniCluster(JobGraph jobGraph, int degreeOfPrallelism, long memorySize) throws Exception {
        Configuration configuration = jobGraph.getJobConfiguration();
        NepheleMiniCluster exec = new NepheleMiniCluster();
        exec.setMemorySize(memorySize);
        exec.setNumTaskManager(1);
        exec.setTaskManagerNumSlots(degreeOfPrallelism);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running on mini cluster");
        }
        try {
            exec.start();
            Client client = new Client(new InetSocketAddress("localhost", exec.getJobManagerRpcPort()), configuration, ClusterUtil.class.getClassLoader());
            client.run(jobGraph, true);
        }
        catch (ProgramInvocationException e) {
            if (e.getMessage().contains("GraphConversionException")) {
                throw new Exception(CANNOT_EXECUTE_EMPTY_JOB, e);
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            exec.stop();
        }
    }

    public static void runOnMiniCluster(JobGraph jobGraph, int numOfSlots) throws Exception {
        ClusterUtil.runOnMiniCluster(jobGraph, numOfSlots, -1L);
    }
}

