/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.state.OperatorState;
import org.apache.flink.streaming.state.PartitionableState;
import org.apache.flink.streaming.state.checkpoint.MapCheckpoint;
import org.apache.flink.streaming.state.checkpoint.StateCheckpoint;

public class MapState<K, V>
extends PartitionableState<Map<K, V>>
implements Map<K, V> {
    private static final long serialVersionUID = 1L;
    protected Set<K> removedItems;
    protected Set<K> updatedItems;
    protected boolean clear;

    public MapState() {
        this.state = new HashMap();
        this.updatedItems = new HashSet<K>();
        this.removedItems = new HashSet<K>();
    }

    @Override
    public StateCheckpoint<Map<K, V>> checkpoint() {
        this.updatedItems.removeAll(this.removedItems);
        MapCheckpoint checkpoint = new MapCheckpoint(this);
        this.resetHistory();
        return checkpoint;
    }

    @Override
    public OperatorState<Map<K, V>> restore(StateCheckpoint<Map<K, V>> checkpoint) {
        this.state = checkpoint.getCheckpointedState();
        this.resetHistory();
        return this;
    }

    @Override
    public OperatorState<Map<K, V>>[] repartition(int numberOfPartitions) {
        MapState[] states = new MapState[numberOfPartitions];
        for (int i = 0; i < numberOfPartitions; ++i) {
            states[i] = new MapState<K, V>();
        }
        for (Map.Entry entry : ((Map)this.state).entrySet()) {
            int partition = Math.abs(entry.getKey().hashCode() % numberOfPartitions);
            ((Map)states[partition].state).put(entry.getKey(), entry.getValue());
        }
        return states;
    }

    @Override
    public OperatorState<Map<K, V>> reBuild(OperatorState<Map<K, V>> ... parts) {
        this.clear();
        for (OperatorState<Map<K, V>> operatorState : parts) {
            this.putAll((Map)operatorState.state);
        }
        return this;
    }

    public void resetHistory() {
        this.clear = false;
        this.removedItems.clear();
        this.updatedItems.clear();
    }

    @Override
    public int size() {
        return ((Map)this.state).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.state).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((Map)this.state).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Map)this.state).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return ((Map)this.state).get(key);
    }

    @Override
    public V put(K key, V value) {
        this.updatedItems.add(key);
        this.removedItems.remove(key);
        return ((Map)this.state).put(key, value);
    }

    @Override
    public V remove(Object key) {
        Object removed = ((Map)this.state).remove(key);
        if (removed != null) {
            this.removedItems.add(key);
            this.updatedItems.remove(key);
        }
        return removed;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.updatedItems.add(key);
            this.removedItems.remove(key);
        }
        ((Map)this.state).putAll(m);
    }

    @Override
    public void clear() {
        this.clear = true;
        this.updatedItems.clear();
        this.removedItems.clear();
        ((Map)this.state).clear();
    }

    @Override
    public Set<K> keySet() {
        return ((Map)this.state).keySet();
    }

    @Override
    public Collection<V> values() {
        return ((Map)this.state).values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((Map)this.state).entrySet();
    }

    @Override
    public Map<K, V> getState() {
        throw new RuntimeException("State object should be accessed using the Map interface provided by the MapState");
    }

    @Override
    public OperatorState<Map<K, V>> setState(Map<K, V> state) {
        throw new RuntimeException("State object should be accessed using the Map interface provided by the MapState");
    }

    public Set<K> getRemovedItems() {
        return this.removedItems;
    }

    public Set<K> getUpdatedItems() {
        return this.updatedItems;
    }

    public boolean isCleared() {
        return this.clear;
    }
}

