/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.io;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.streaming.io.CoRecordReader;

public class CoReaderIterator<T1, T2> {
    private final CoRecordReader<DeserializationDelegate<T1>, DeserializationDelegate<T2>> reader;
    protected final DeserializationDelegate<T1> delegate1;
    protected final DeserializationDelegate<T2> delegate2;

    public CoReaderIterator(CoRecordReader<DeserializationDelegate<T1>, DeserializationDelegate<T2>> reader, TypeSerializer<T1> serializer1, TypeSerializer<T2> serializer2) {
        this.reader = reader;
        this.delegate1 = new DeserializationDelegate(serializer1);
        this.delegate2 = new DeserializationDelegate(serializer2);
    }

    public int next(T1 target1, T2 target2) throws IOException {
        this.delegate1.setInstance(target1);
        this.delegate2.setInstance(target2);
        try {
            return this.reader.getNextRecord(this.delegate1, this.delegate2);
        }
        catch (InterruptedException e) {
            throw new IOException("Reader interrupted.", e);
        }
    }
}

