/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamvertex;

import java.util.ArrayList;
import org.apache.flink.runtime.io.network.api.MutableRecordReader;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.streaming.api.invokable.operator.co.CoInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.OutputHandler;
import org.apache.flink.streaming.api.streamvertex.StreamVertex;
import org.apache.flink.streaming.api.streamvertex.StreamVertexException;
import org.apache.flink.streaming.io.CoReaderIterator;
import org.apache.flink.streaming.io.CoRecordReader;
import org.apache.flink.util.MutableObjectIterator;

public class CoStreamVertex<IN1, IN2, OUT>
extends StreamVertex<IN1, OUT> {
    protected StreamRecordSerializer<IN1> inputDeserializer1 = null;
    protected StreamRecordSerializer<IN2> inputDeserializer2 = null;
    MutableObjectIterator<StreamRecord<IN1>> inputIter1;
    MutableObjectIterator<StreamRecord<IN2>> inputIter2;
    CoRecordReader<DeserializationDelegate<StreamRecord<IN1>>, DeserializationDelegate<StreamRecord<IN2>>> coReader;
    CoReaderIterator<StreamRecord<IN1>, StreamRecord<IN2>> coIter;
    private CoInvokable<IN1, IN2, OUT> userInvokable = null;
    private static int numTasks;

    public CoStreamVertex() {
        this.instanceID = numTasks = CoStreamVertex.newVertex();
    }

    private void setDeserializers() {
        this.inputDeserializer1 = this.configuration.getTypeSerializerIn1(this.userClassLoader);
        this.inputDeserializer2 = this.configuration.getTypeSerializerIn2(this.userClassLoader);
    }

    @Override
    public void setInputsOutputs() {
        this.outputHandler = new OutputHandler(this);
        this.setConfigInputs();
        this.coIter = new CoReaderIterator(this.coReader, this.inputDeserializer1, this.inputDeserializer2);
    }

    @Override
    protected void setInvokable() {
        this.userInvokable = (CoInvokable)this.configuration.getUserInvokable(this.userClassLoader);
        this.userInvokable.setup(this);
    }

    protected void setConfigInputs() throws StreamVertexException {
        this.setDeserializers();
        int numberOfInputs = this.configuration.getNumberOfInputs();
        ArrayList inputList1 = new ArrayList();
        ArrayList inputList2 = new ArrayList();
        block4: for (int i = 0; i < numberOfInputs; ++i) {
            int inputType = this.configuration.getInputType(i);
            switch (inputType) {
                case 1: {
                    inputList1.add(new MutableRecordReader((AbstractInvokable)this));
                    continue block4;
                }
                case 2: {
                    inputList2.add(new MutableRecordReader((AbstractInvokable)this));
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Invalid input type number: " + inputType);
                }
            }
        }
        this.coReader = new CoRecordReader(inputList1, inputList2);
    }

    @Override
    public void invoke() throws Exception {
        this.outputHandler.invokeUserFunction("CO-TASK", this.userInvokable);
    }

    @Override
    public <X> MutableObjectIterator<X> getInput(int index) {
        switch (index) {
            case 0: {
                return this.inputIter1;
            }
            case 1: {
                return this.inputIter2;
            }
        }
        throw new IllegalArgumentException("CoStreamVertex has only 2 inputs");
    }

    @Override
    public <X> StreamRecordSerializer<X> getInputSerializer(int index) {
        switch (index) {
            case 0: {
                return this.inputDeserializer1;
            }
            case 1: {
                return this.inputDeserializer2;
            }
        }
        throw new IllegalArgumentException("CoStreamVertex has only 2 inputs");
    }

    @Override
    public <X, Y> CoReaderIterator<X, Y> getCoReader() {
        return this.coIter;
    }
}

