/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator.co;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.StreamTaskContext;
import org.apache.flink.streaming.io.CoReaderIterator;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoInvokable<IN1, IN2, OUT>
extends StreamInvokable<IN1, OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CoInvokable.class);
    protected CoReaderIterator<StreamRecord<IN1>, StreamRecord<IN2>> recordIterator;
    protected StreamRecord<IN1> reuse1;
    protected StreamRecord<IN2> reuse2;
    protected StreamRecordSerializer<IN1> srSerializer1;
    protected StreamRecordSerializer<IN2> srSerializer2;
    protected TypeSerializer<IN1> serializer1;
    protected TypeSerializer<IN2> serializer2;

    public CoInvokable(Function userFunction) {
        super(userFunction);
    }

    @Override
    public void setup(StreamTaskContext<OUT> taskContext) {
        this.collector = taskContext.getOutputCollector();
        this.recordIterator = taskContext.getCoReader();
        this.srSerializer1 = taskContext.getInputSerializer(0);
        this.srSerializer2 = taskContext.getInputSerializer(1);
        this.reuse1 = this.srSerializer1.createInstance();
        this.reuse2 = this.srSerializer2.createInstance();
        this.serializer1 = this.srSerializer1.getObjectSerializer();
        this.serializer2 = this.srSerializer2.getObjectSerializer();
    }

    protected void resetReuseAll() {
        this.reuse1 = this.srSerializer1.createInstance();
        this.reuse2 = this.srSerializer2.createInstance();
    }

    protected void resetReuse1() {
        this.reuse1 = this.srSerializer1.createInstance();
    }

    protected void resetReuse2() {
        this.reuse2 = this.srSerializer2.createInstance();
    }

    @Override
    public void invoke() throws Exception {
        int next;
        while ((next = this.recordIterator.next(this.reuse1, this.reuse2)) != 0) {
            if (next == 1) {
                this.initialize1();
                this.handleStream1();
                this.resetReuse1();
                continue;
            }
            this.initialize2();
            this.handleStream2();
            this.resetReuse2();
        }
    }

    protected abstract void handleStream1() throws Exception;

    protected abstract void handleStream2() throws Exception;

    protected abstract void callUserFunction1() throws Exception;

    protected abstract void callUserFunction2() throws Exception;

    protected void initialize1() {
    }

    protected void initialize2() {
    }

    protected void callUserFunctionAndLogException1() {
        block2: {
            try {
                this.callUserFunction1();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Calling user function failed due to: {}", (Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    protected void callUserFunctionAndLogException2() {
        block2: {
            try {
                this.callUserFunction2();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Calling user function failed due to: {}", (Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }
}

