/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator.co;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.function.co.CoReduceFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoReduceInvokable;

public class CoGroupedReduceInvokable<IN1, IN2, OUT>
extends CoReduceInvokable<IN1, IN2, OUT> {
    private static final long serialVersionUID = 1L;
    protected KeySelector<IN1, ?> keySelector1;
    protected KeySelector<IN2, ?> keySelector2;
    private Map<Object, IN1> values1;
    private Map<Object, IN2> values2;
    IN1 reduced1;
    IN2 reduced2;

    public CoGroupedReduceInvokable(CoReduceFunction<IN1, IN2, OUT> coReducer, KeySelector<IN1, ?> keySelector1, KeySelector<IN2, ?> keySelector2) {
        super(coReducer);
        this.coReducer = coReducer;
        this.keySelector1 = keySelector1;
        this.keySelector2 = keySelector2;
        this.values1 = new HashMap<Object, IN1>();
        this.values2 = new HashMap<Object, IN2>();
    }

    @Override
    public void handleStream1() throws Exception {
        Object key = this.reuse1.getKey(this.keySelector1);
        this.currentValue1 = this.values1.get(key);
        this.nextValue1 = this.reuse1.getObject();
        if (this.currentValue1 != null) {
            this.callUserFunctionAndLogException1();
            this.values1.put(key, this.reduced1);
            this.collector.collect(this.coReducer.map1(this.reduced1));
        } else {
            this.values1.put(key, this.nextValue1);
            this.collector.collect(this.coReducer.map1(this.nextValue1));
        }
    }

    @Override
    public void handleStream2() throws Exception {
        Object key = this.reuse2.getKey(this.keySelector2);
        this.currentValue2 = this.values2.get(key);
        this.nextValue2 = this.reuse2.getObject();
        if (this.currentValue2 != null) {
            this.callUserFunctionAndLogException2();
            this.values2.put(key, this.reduced2);
            this.collector.collect(this.coReducer.map2(this.reduced2));
        } else {
            this.values2.put(key, this.nextValue2);
            this.collector.collect(this.coReducer.map2(this.nextValue2));
        }
    }

    @Override
    protected void callUserFunction1() throws Exception {
        this.reduced1 = this.coReducer.reduce1(this.currentValue1, this.nextValue1);
    }

    @Override
    protected void callUserFunction2() throws Exception {
        this.reduced2 = this.coReducer.reduce2(this.currentValue2, this.nextValue2);
    }
}

