/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.windowing.policy.ActiveEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.ActiveTriggerCallback;
import org.apache.flink.streaming.api.windowing.policy.ActiveTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;

public abstract class WindowInvokable<IN, OUT>
extends StreamInvokable<IN, OUT> {
    private static final long serialVersionUID = -8038984294071650730L;
    private LinkedList<TriggerPolicy<IN>> triggerPolicies;
    private LinkedList<EvictionPolicy<IN>> evictionPolicies;
    private LinkedList<ActiveTriggerPolicy<IN>> activeTriggerPolicies;
    private LinkedList<ActiveEvictionPolicy<IN>> activeEvictionPolicies;
    private LinkedList<Thread> activePolicyTreads;
    protected LinkedList<IN> buffer;
    private LinkedList<TriggerPolicy<IN>> currentTriggerPolicies;

    public WindowInvokable(Function userFunction, LinkedList<TriggerPolicy<IN>> triggerPolicies, LinkedList<EvictionPolicy<IN>> evictionPolicies) {
        super(userFunction);
        this.triggerPolicies = triggerPolicies;
        this.evictionPolicies = evictionPolicies;
        this.activeTriggerPolicies = new LinkedList();
        for (TriggerPolicy triggerPolicy : triggerPolicies) {
            if (!(triggerPolicy instanceof ActiveTriggerPolicy)) continue;
            this.activeTriggerPolicies.add((ActiveTriggerPolicy)triggerPolicy);
        }
        this.activeEvictionPolicies = new LinkedList();
        for (EvictionPolicy evictionPolicy : evictionPolicies) {
            if (!(evictionPolicy instanceof ActiveEvictionPolicy)) continue;
            this.activeEvictionPolicies.add((ActiveEvictionPolicy)evictionPolicy);
        }
        this.activePolicyTreads = new LinkedList();
        this.buffer = new LinkedList();
        this.currentTriggerPolicies = new LinkedList();
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        for (ActiveTriggerPolicy activeTriggerPolicy : this.activeTriggerPolicies) {
            Runnable target = activeTriggerPolicy.createActiveTriggerRunnable(new WindowingCallback(activeTriggerPolicy));
            if (target == null) continue;
            Thread thread = new Thread(target);
            this.activePolicyTreads.add(thread);
            thread.start();
        }
    }

    @Override
    public void invoke() throws Exception {
        if (this.readNext() == null) {
            throw new RuntimeException("DataStream must not be empty");
        }
        while (this.nextRecord != null) {
            this.processRealElement(this.nextRecord.getObject());
            this.readNext();
        }
        for (Thread t : this.activePolicyTreads) {
            t.interrupt();
        }
        this.emitFinalWindow(null);
    }

    protected synchronized void externalTriggerFakeElement(IN input, List<TriggerPolicy<IN>> policies) {
        this.currentTriggerPolicies.addAll(policies);
        this.callUserFunctionAndLogException();
        this.currentTriggerPolicies.clear();
        int currentMaxEviction = 0;
        for (ActiveEvictionPolicy activeEvictionPolicy : this.activeEvictionPolicies) {
            int tmp = activeEvictionPolicy.notifyEvictionWithFakeElement(input, this.buffer.size());
            if (tmp <= currentMaxEviction) continue;
            currentMaxEviction = tmp;
        }
        for (int i = 0; i < currentMaxEviction; ++i) {
            try {
                this.buffer.removeFirst();
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
    }

    protected synchronized void processFakeElement(Object input, TriggerPolicy<IN> currentPolicy) {
        int currentMaxEviction = 0;
        for (ActiveEvictionPolicy activeEvictionPolicy : this.activeEvictionPolicies) {
            int tmp = activeEvictionPolicy.notifyEvictionWithFakeElement(input, this.buffer.size());
            if (tmp <= currentMaxEviction) continue;
            currentMaxEviction = tmp;
        }
        for (int i = 0; i < currentMaxEviction; ++i) {
            try {
                this.buffer.removeFirst();
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        this.currentTriggerPolicies.add(currentPolicy);
        this.callUserFunctionAndLogException();
        this.currentTriggerPolicies.clear();
    }

    protected synchronized void processRealElement(IN input, List<TriggerPolicy<IN>> triggerPolicies) {
        this.currentTriggerPolicies.addAll(triggerPolicies);
        this.processRealElement(input);
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void processRealElement(IN input) {
        void var4_13;
        int n;
        for (ActiveTriggerPolicy activeTriggerPolicy : this.activeTriggerPolicies) {
            Object[] objectArray;
            for (Object in : objectArray = activeTriggerPolicy.preNotifyTrigger(input)) {
                this.processFakeElement(in, activeTriggerPolicy);
            }
        }
        boolean isTriggered = false;
        for (TriggerPolicy triggerPolicy : this.triggerPolicies) {
            if (!triggerPolicy.notifyTrigger(input)) continue;
            this.currentTriggerPolicies.add(triggerPolicy);
        }
        if (!this.currentTriggerPolicies.isEmpty()) {
            this.callUserFunctionAndLogException();
            this.currentTriggerPolicies.clear();
            isTriggered = true;
        }
        boolean bl = false;
        for (EvictionPolicy evictionPolicy : this.evictionPolicies) {
            int tmp = evictionPolicy.notifyEviction(input, isTriggered, this.buffer.size());
            if (tmp <= n) continue;
            n = tmp;
        }
        boolean bl2 = false;
        while (var4_13 < n) {
            try {
                this.buffer.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            ++var4_13;
        }
        this.buffer.add(input);
    }

    protected synchronized void evictFirst() {
        try {
            this.buffer.removeFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    protected boolean isBufferEmpty() {
        return this.buffer.isEmpty();
    }

    protected void emitFinalWindow(List<TriggerPolicy<IN>> centralTriggerPolicies) {
        if (!this.buffer.isEmpty()) {
            this.currentTriggerPolicies.clear();
            if (centralTriggerPolicies != null) {
                this.currentTriggerPolicies.addAll(centralTriggerPolicies);
            }
            for (TriggerPolicy triggerPolicy : this.triggerPolicies) {
                this.currentTriggerPolicies.add(triggerPolicy);
            }
            this.callUserFunctionAndLogException();
        }
    }

    private class WindowingCallback
    implements ActiveTriggerCallback {
        private ActiveTriggerPolicy<IN> policy;

        public WindowingCallback(ActiveTriggerPolicy<IN> policy) {
            this.policy = policy;
        }

        @Override
        public void sendFakeElement(Object datapoint) {
            WindowInvokable.this.processFakeElement(datapoint, this.policy);
        }
    }
}

