/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.StreamTaskContext;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamInvokable<IN, OUT>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StreamInvokable.class);
    protected StreamTaskContext<OUT> taskContext;
    protected MutableObjectIterator<StreamRecord<IN>> recordIterator;
    protected StreamRecordSerializer<IN> inSerializer;
    protected TypeSerializer<IN> objectSerializer;
    protected StreamRecord<IN> nextRecord;
    protected boolean isMutable;
    protected Collector<OUT> collector;
    protected Function userFunction;
    protected volatile boolean isRunning;

    public StreamInvokable(Function userFunction) {
        this.userFunction = userFunction;
    }

    public void setup(StreamTaskContext<OUT> taskContext) {
        this.collector = taskContext.getOutputCollector();
        this.recordIterator = taskContext.getInput(0);
        this.inSerializer = taskContext.getInputSerializer(0);
        if (this.inSerializer != null) {
            this.nextRecord = this.inSerializer.createInstance();
            this.objectSerializer = this.inSerializer.getObjectSerializer();
        }
        this.taskContext = taskContext;
    }

    public abstract void invoke() throws Exception;

    protected StreamRecord<IN> readNext() {
        this.nextRecord = this.inSerializer.createInstance();
        try {
            this.nextRecord = (StreamRecord)this.recordIterator.next(this.nextRecord);
            return this.nextRecord;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read next record.");
        }
    }

    protected void callUserFunction() throws Exception {
    }

    protected void callUserFunctionAndLogException() {
        block2: {
            try {
                this.callUserFunction();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Calling user function failed due to: {}", (Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public void open(Configuration parameters) throws Exception {
        this.isRunning = true;
        FunctionUtils.openFunction((Function)this.userFunction, (Configuration)parameters);
    }

    public void close() throws Exception {
        this.isRunning = false;
        this.collector.close();
        FunctionUtils.closeFunction((Function)this.userFunction);
    }

    public void setRuntimeContext(RuntimeContext t) {
        FunctionUtils.setFunctionRuntimeContext((Function)this.userFunction, (RuntimeContext)t);
    }

    protected IN copy(IN record) {
        return (IN)this.objectSerializer.copy(record);
    }
}

