/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.source;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.function.source.RichParallelSourceFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.NumberSequenceIterator;

public class GenSequenceFunction
extends RichParallelSourceFunction<Long> {
    private static final long serialVersionUID = 1L;
    private NumberSequenceIterator fullIterator;
    private NumberSequenceIterator splitIterator;

    public GenSequenceFunction(long from, long to) {
        this.fullIterator = new NumberSequenceIterator(from, to);
    }

    @Override
    public void invoke(Collector<Long> collector) throws Exception {
        while (this.splitIterator.hasNext()) {
            collector.collect((Object)this.splitIterator.next());
        }
    }

    public void open(Configuration config) {
        int splitNumber = this.getRuntimeContext().getIndexOfThisSubtask();
        int numOfSubTasks = this.getRuntimeContext().getNumberOfParallelSubtasks();
        this.splitIterator = this.fullIterator.split(numOfSubTasks)[splitNumber];
    }
}

