/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.source;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.util.Collector;

public class FromElementsFunction<T>
implements SourceFunction<T> {
    private static final long serialVersionUID = 1L;
    Iterable<T> iterable;

    public FromElementsFunction(T ... elements) {
        this.iterable = Arrays.asList(elements);
    }

    public FromElementsFunction(Collection<T> elements) {
        this.iterable = elements;
    }

    public FromElementsFunction(Iterable<T> elements) {
        this.iterable = elements;
    }

    @Override
    public void invoke(Collector<T> collector) throws Exception {
        for (T element : this.iterable) {
            collector.collect(element);
        }
    }
}

