/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.source;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.util.Collector;

public class FileStreamFunction
implements SourceFunction<String> {
    private static final long serialVersionUID = 1L;
    private final String path;

    public FileStreamFunction(String path) {
        this.path = path;
    }

    @Override
    public void invoke(Collector<String> collector) throws IOException {
        while (true) {
            BufferedReader br = new BufferedReader(new FileReader(this.path));
            String line = br.readLine();
            while (line != null) {
                if (!line.equals("")) {
                    collector.collect((Object)line);
                }
                line = br.readLine();
            }
            br.close();
        }
    }
}

