/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.co;

import java.util.List;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.function.co.CoWindowFunction;
import org.apache.flink.util.Collector;

public class JoinWindowFunction<IN1, IN2, OUT>
implements CoWindowFunction<IN1, IN2, OUT> {
    private static final long serialVersionUID = 1L;
    private KeySelector<IN1, ?> keySelector1;
    private KeySelector<IN2, ?> keySelector2;
    private JoinFunction<IN1, IN2, OUT> joinFunction;

    public JoinWindowFunction(KeySelector<IN1, ?> keySelector1, KeySelector<IN2, ?> keySelector2, JoinFunction<IN1, IN2, OUT> joinFunction) {
        this.keySelector1 = keySelector1;
        this.keySelector2 = keySelector2;
        this.joinFunction = joinFunction;
    }

    @Override
    public void coWindow(List<IN1> first, List<IN2> second, Collector<OUT> out) throws Exception {
        for (IN1 item1 : first) {
            Object key1 = this.keySelector1.getKey(item1);
            for (IN2 item2 : second) {
                Object key2 = this.keySelector2.getKey(item2);
                if (!key1.equals(key2)) continue;
                out.collect(this.joinFunction.join(item1, item2));
            }
        }
    }
}

