/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.function.aggregation;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.streaming.api.function.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.function.aggregation.Comparator;

public abstract class ComparableAggregator<T>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;
    public Comparator comparator;
    public boolean byAggregate;
    public boolean first;

    public ComparableAggregator(int pos, AggregationFunction.AggregationType aggregationType, boolean first) {
        super(pos);
        this.comparator = Comparator.getForAggregation(aggregationType);
        this.byAggregate = aggregationType == AggregationFunction.AggregationType.MAXBY || aggregationType == AggregationFunction.AggregationType.MINBY;
        this.first = first;
    }

    public static <R> AggregationFunction<R> getAggregator(int positionToAggregate, TypeInformation<R> typeInfo, AggregationFunction.AggregationType aggregationType) {
        return ComparableAggregator.getAggregator(positionToAggregate, typeInfo, aggregationType, false);
    }

    public static <R> AggregationFunction<R> getAggregator(int positionToAggregate, TypeInformation<R> typeInfo, AggregationFunction.AggregationType aggregationType, boolean first) {
        if (typeInfo.isTupleType()) {
            return new TupleComparableAggregator(positionToAggregate, aggregationType, first);
        }
        if (typeInfo instanceof BasicArrayTypeInfo || typeInfo instanceof PrimitiveArrayTypeInfo) {
            return new ArrayComparableAggregator(positionToAggregate, aggregationType, first);
        }
        return new SimpleComparableAggregator(aggregationType);
    }

    public static <R> AggregationFunction<R> getAggregator(String field, TypeInformation<R> typeInfo, AggregationFunction.AggregationType aggregationType, boolean first) {
        return new PojoComparableAggregator(field, typeInfo, aggregationType, first);
    }

    private static class PojoComparableAggregator<T>
    extends ComparableAggregator<T> {
        private static final long serialVersionUID = 1L;
        PojoComparator<T> pojoComparator;

        public PojoComparableAggregator(String field, TypeInformation<?> typeInfo, AggregationFunction.AggregationType aggregationType, boolean first) {
            super(0, aggregationType, first);
            if (!(typeInfo instanceof CompositeType)) {
                throw new IllegalArgumentException("Key expressions are only supported on POJO types and Tuples. A type is considered a POJO if all its fields are public, or have both getters and setters defined");
            }
            CompositeType cType = (CompositeType)typeInfo;
            ArrayList fieldDescriptors = new ArrayList();
            cType.getKey(field, 0, fieldDescriptors);
            int logicalKeyPosition = ((CompositeType.FlatFieldDescriptor)fieldDescriptors.get(0)).getPosition();
            if (!(cType instanceof PojoTypeInfo)) {
                throw new IllegalArgumentException("Key expressions are only supported on POJO types. A type is considered a POJO if all its fields are public, or have both getters and setters defined");
            }
            this.pojoComparator = (PojoComparator)cType.createComparator(new int[]{logicalKeyPosition}, new boolean[]{false}, 0);
        }

        public T reduce(T value1, T value2) throws Exception {
            Field[] keyFields = this.pojoComparator.getKeyFields();
            Object field1 = this.pojoComparator.accessField(keyFields[0], value1);
            Object field2 = this.pojoComparator.accessField(keyFields[0], value2);
            int c = this.comparator.isExtremal((Comparable)field1, field2);
            if (this.byAggregate) {
                if (c == 1) {
                    return value1;
                }
                if (this.first && c == 0) {
                    return value1;
                }
                return value2;
            }
            if (c == 1) {
                keyFields[0].set(value2, field1);
            }
            return value2;
        }
    }

    private static class SimpleComparableAggregator<T>
    extends ComparableAggregator<T> {
        private static final long serialVersionUID = 1L;

        public SimpleComparableAggregator(AggregationFunction.AggregationType aggregationType) {
            super(0, aggregationType, false);
        }

        public T reduce(T value1, T value2) throws Exception {
            if (this.comparator.isExtremal((Comparable)value1, value2) == 1) {
                return value1;
            }
            return value2;
        }
    }

    private static class ArrayComparableAggregator<T>
    extends ComparableAggregator<T> {
        private static final long serialVersionUID = 1L;

        public ArrayComparableAggregator(int pos, AggregationFunction.AggregationType aggregationType, boolean first) {
            super(pos, aggregationType, first);
        }

        public T reduce(T array1, T array2) throws Exception {
            Object v1 = Array.get(array1, this.position);
            Object v2 = Array.get(array2, this.position);
            int c = this.comparator.isExtremal((Comparable)v1, v2);
            if (this.byAggregate) {
                if (c == 1) {
                    return array1;
                }
                if (this.first && c == 0) {
                    return array1;
                }
                return array2;
            }
            if (c == 1) {
                Array.set(array2, this.position, v1);
            }
            return array2;
        }
    }

    private static class TupleComparableAggregator<T>
    extends ComparableAggregator<T> {
        private static final long serialVersionUID = 1L;

        public TupleComparableAggregator(int pos, AggregationFunction.AggregationType aggregationType, boolean first) {
            super(pos, aggregationType, first);
        }

        public T reduce(T value1, T value2) throws Exception {
            Tuple tuple1 = (Tuple)value1;
            Tuple tuple2 = (Tuple)value2;
            Comparable o1 = (Comparable)tuple1.getField(this.position);
            Object o2 = tuple2.getField(this.position);
            int c = this.comparator.isExtremal(o1, o2);
            if (this.byAggregate) {
                if (c == 1) {
                    return (T)tuple1;
                }
                if (this.first && c == 0) {
                    return (T)tuple1;
                }
                return (T)tuple2;
            }
            if (c == 1) {
                tuple2.setField((Object)o1, this.position);
            }
            return (T)tuple2;
        }
    }
}

