/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.JobGraphBuilder;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamContextEnvironment;
import org.apache.flink.streaming.api.function.source.FileSourceFunction;
import org.apache.flink.streaming.api.function.source.FileStreamFunction;
import org.apache.flink.streaming.api.function.source.FromElementsFunction;
import org.apache.flink.streaming.api.function.source.GenSequenceFunction;
import org.apache.flink.streaming.api.function.source.GenericSourceFunction;
import org.apache.flink.streaming.api.function.source.ParallelSourceFunction;
import org.apache.flink.streaming.api.function.source.SocketTextStreamFunction;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.api.invokable.SourceInvokable;

public abstract class StreamExecutionEnvironment {
    private static int defaultLocalDop = Runtime.getRuntime().availableProcessors();
    private long bufferTimeout = 100L;
    private ExecutionConfig config = new ExecutionConfig();
    protected JobGraphBuilder jobGraphBuilder = new JobGraphBuilder();

    protected StreamExecutionEnvironment() {
    }

    public void setConfig(ExecutionConfig config) {
        Validate.notNull((Object)config);
        this.config = config;
    }

    public ExecutionConfig getConfig() {
        return this.config;
    }

    public int getDegreeOfParallelism() {
        return this.config.getDegreeOfParallelism();
    }

    public StreamExecutionEnvironment setDegreeOfParallelism(int degreeOfParallelism) {
        if (degreeOfParallelism < 1) {
            throw new IllegalArgumentException("Degree of parallelism must be at least one.");
        }
        this.config.setDegreeOfParallelism(degreeOfParallelism);
        return this;
    }

    public StreamExecutionEnvironment setBufferTimeout(long timeoutMillis) {
        if (timeoutMillis < -1L) {
            throw new IllegalArgumentException("Timeout of buffer must be non-negative or -1");
        }
        this.bufferTimeout = timeoutMillis;
        return this;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public static void setDefaultLocalParallelism(int degreeOfParallelism) {
        defaultLocalDop = degreeOfParallelism;
    }

    public DataStreamSource<String> readTextFile(String filePath) {
        Validate.notNull((Object)filePath, (String)"The file path may not be null.", (Object[])new Object[0]);
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        BasicTypeInfo typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        return this.addFileSource((InputFormat<String, ?>)format, (TypeInformation<String>)typeInfo);
    }

    public DataStreamSource<String> readTextFile(String filePath, String charsetName) {
        Validate.notNull((Object)filePath, (String)"The file path may not be null.", (Object[])new Object[0]);
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        BasicTypeInfo typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        format.setCharsetName(charsetName);
        return this.addFileSource((InputFormat<String, ?>)format, (TypeInformation<String>)typeInfo);
    }

    public DataStreamSource<String> readTextStream(String filePath) {
        StreamExecutionEnvironment.checkIfFileExists(filePath);
        return this.addSource(new FileStreamFunction(filePath), null, "textStream");
    }

    private static void checkIfFileExists(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + filePath);
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Cannot read file: " + filePath);
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Given path is a directory: " + filePath);
        }
    }

    public <OUT extends Serializable> DataStreamSource<OUT> fromElements(OUT ... data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("fromElements needs at least one element as argument");
        }
        TypeInformation outTypeInfo = TypeExtractor.getForObject(data[0]);
        FromElementsFunction<OUT> function = new FromElementsFunction<OUT>(data);
        return this.addSource(function, outTypeInfo, "elements");
    }

    public <OUT extends Serializable> DataStreamSource<OUT> fromCollection(Collection<OUT> data) {
        if (data == null) {
            throw new NullPointerException("Collection must not be null");
        }
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Collection must not be empty");
        }
        TypeInformation outTypeInfo = TypeExtractor.getForObject(data.iterator().next());
        FromElementsFunction<OUT> function = new FromElementsFunction<OUT>(data);
        return this.addSource(function, outTypeInfo, "collection");
    }

    public DataStreamSource<String> socketTextStream(String hostname, int port, char delimiter) {
        return this.addSource(new SocketTextStreamFunction(hostname, port, delimiter), null, "socketStrean");
    }

    public DataStreamSource<String> socketTextStream(String hostname, int port) {
        return this.socketTextStream(hostname, port, '\n');
    }

    public DataStreamSource<Long> generateSequence(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("Start of sequence must not be greater than the end");
        }
        return this.addSource(new GenSequenceFunction(from, to), null, "sequence");
    }

    private DataStreamSource<String> addFileSource(InputFormat<String, ?> inputFormat, TypeInformation<String> typeInfo) {
        FileSourceFunction function = new FileSourceFunction(inputFormat, typeInfo);
        DataStreamSource<String> returnStream = this.addSource(function, null, "fileSource");
        this.jobGraphBuilder.setInputFormat(returnStream.getId(), inputFormat);
        return returnStream;
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function) {
        return this.addSource(function, null);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, TypeInformation<OUT> outTypeInfo) {
        return this.addSource(function, outTypeInfo, function.getClass().getName());
    }

    private <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, TypeInformation<OUT> outTypeInfo, String sourceName) {
        boolean isParallel;
        if (outTypeInfo == null) {
            outTypeInfo = function instanceof GenericSourceFunction ? ((GenericSourceFunction)((Object)function)).getType() : TypeExtractor.createTypeInfo(SourceFunction.class, function.getClass(), (int)0, null, null);
        }
        int dop = (isParallel = function instanceof ParallelSourceFunction) ? this.getDegreeOfParallelism() : 1;
        DataStreamSource returnStream = new DataStreamSource(this, sourceName, outTypeInfo, isParallel);
        this.jobGraphBuilder.addStreamVertex(returnStream.getId(), new SourceInvokable<OUT>(function), null, outTypeInfo, sourceName, dop);
        return returnStream;
    }

    public static StreamExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (env instanceof ContextEnvironment) {
            ContextEnvironment ctx = (ContextEnvironment)env;
            return StreamExecutionEnvironment.createContextEnvironment(ctx.getClient(), ctx.getJars(), ctx.getDegreeOfParallelism());
        }
        return StreamExecutionEnvironment.createLocalEnvironment();
    }

    private static StreamExecutionEnvironment createContextEnvironment(Client client, List<File> jars, int dop) {
        return new StreamContextEnvironment(client, jars, dop);
    }

    public static LocalStreamEnvironment createLocalEnvironment() {
        return StreamExecutionEnvironment.createLocalEnvironment(defaultLocalDop);
    }

    public static LocalStreamEnvironment createLocalEnvironment(int degreeOfParallelism) {
        LocalStreamEnvironment lee = new LocalStreamEnvironment();
        lee.setDegreeOfParallelism(degreeOfParallelism);
        return lee;
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, String ... jarFiles) {
        return new RemoteStreamEnvironment(host, port, jarFiles);
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, int degreeOfParallelism, String ... jarFiles) {
        RemoteStreamEnvironment rec = new RemoteStreamEnvironment(host, port, jarFiles);
        rec.setDegreeOfParallelism(degreeOfParallelism);
        return rec;
    }

    public abstract void execute() throws Exception;

    public abstract void execute(String var1) throws Exception;

    public JobGraphBuilder getJobGraphBuilder() {
        return this.jobGraphBuilder;
    }
}

