/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStreamEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteStreamEnvironment.class);
    private String host;
    private int port;
    private List<File> jarFiles;

    public RemoteStreamEnvironment(String host, int port, String ... jarFiles) {
        if (host == null) {
            throw new NullPointerException("Host must not be null.");
        }
        if (port < 1 || port >= 65535) {
            throw new IllegalArgumentException("Port out of range");
        }
        this.host = host;
        this.port = port;
        this.jarFiles = new ArrayList<File>();
        for (int i = 0; i < jarFiles.length; ++i) {
            File file = new File(jarFiles[i]);
            try {
                JobWithJars.checkJarFile((File)file);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem with jar file " + file.getAbsolutePath(), e);
            }
            this.jarFiles.add(file);
        }
    }

    @Override
    public void execute() {
        JobGraph jobGraph = this.jobGraphBuilder.getJobGraph();
        this.executeRemotely(jobGraph);
    }

    @Override
    public void execute(String jobName) {
        JobGraph jobGraph = this.jobGraphBuilder.getJobGraph(jobName);
        this.executeRemotely(jobGraph);
    }

    private void executeRemotely(JobGraph jobGraph) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Running remotely at {}:{}", (Object)this.host, (Object)this.port);
        }
        for (File file : this.jarFiles) {
            jobGraph.addJar(new Path(file.getAbsolutePath()));
        }
        Configuration configuration = jobGraph.getJobConfiguration();
        Client client = new Client(new InetSocketAddress(this.host, this.port), configuration, JobWithJars.buildUserCodeClassLoader(this.jarFiles, (ClassLoader)JobWithJars.class.getClassLoader()));
        try {
            client.run(jobGraph, true);
        }
        catch (ProgramInvocationException e) {
            throw new RuntimeException("Cannot execute job due to ProgramInvocationException", e);
        }
    }

    public String toString() {
        return "Remote Environment (" + this.host + ":" + this.port + " - DOP = " + (this.getDegreeOfParallelism() == -1 ? "default" : Integer.valueOf(this.getDegreeOfParallelism())) + ")";
    }
}

