/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream.temporaloperator;

import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.temporaloperator.TemporalWindow;
import org.apache.flink.streaming.api.windowing.helper.SystemTimestamp;
import org.apache.flink.streaming.api.windowing.helper.Timestamp;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;

public abstract class TemporalOperator<I1, I2, OP extends TemporalWindow<OP>> {
    public final DataStream<I1> input1;
    public final DataStream<I2> input2;
    public long windowSize;
    public long slideInterval;
    public TimestampWrapper<I1> timeStamp1;
    public TimestampWrapper<I2> timeStamp2;

    public TemporalOperator(DataStream<I1> input1, DataStream<I2> input2) {
        if (input1 == null || input2 == null) {
            throw new NullPointerException();
        }
        this.input1 = input1.copy();
        this.input2 = input2.copy();
    }

    public OP onWindow(long length, TimeUnit timeUnit) {
        return this.onWindow(timeUnit.toMillis(length), SystemTimestamp.getWrapper(), SystemTimestamp.getWrapper());
    }

    public OP onWindow(long length, Timestamp<I1> timeStamp1, Timestamp<I2> timeStamp2) {
        return this.onWindow(length, timeStamp1, timeStamp2, 0L);
    }

    public OP onWindow(long length, Timestamp<I1> timeStamp1, Timestamp<I2> timeStamp2, long startTime) {
        return this.onWindow(length, new TimestampWrapper<I1>(timeStamp1, startTime), new TimestampWrapper<I2>(timeStamp2, startTime));
    }

    private OP onWindow(long length, TimestampWrapper<I1> timeStamp1, TimestampWrapper<I2> timeStamp2) {
        this.windowSize = length;
        this.slideInterval = length;
        this.timeStamp1 = timeStamp1;
        this.timeStamp2 = timeStamp2;
        return this.createNextWindowOperator();
    }

    protected abstract OP createNextWindowOperator();
}

