/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream.temporaloperator;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.temporaloperator.TemporalOperator;
import org.apache.flink.streaming.api.datastream.temporaloperator.TemporalWindow;
import org.apache.flink.streaming.api.function.co.JoinWindowFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoWindowInvokable;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;

public class StreamJoinOperator<I1, I2>
extends TemporalOperator<I1, I2, JoinWindow<I1, I2>> {
    public StreamJoinOperator(DataStream<I1> input1, DataStream<I2> input2) {
        super(input1, input2);
    }

    @Override
    protected JoinWindow<I1, I2> createNextWindowOperator() {
        return new JoinWindow(this);
    }

    public static <I1, I2, OUT> JoinWindowFunction<I1, I2, OUT> getJoinWindowFunction(JoinFunction<I1, I2, OUT> joinFunction, JoinPredicate<I1, I2> predicate) {
        return new JoinWindowFunction<I1, I2, OUT>(((JoinPredicate)predicate).keys1, ((JoinPredicate)predicate).keys2, joinFunction);
    }

    public static final class DefaultJoinFunction<I1, I2>
    implements JoinFunction<I1, I2, Tuple2<I1, I2>> {
        private static final long serialVersionUID = 1L;
        private final Tuple2<I1, I2> outTuple = new Tuple2();

        public Tuple2<I1, I2> join(I1 first, I2 second) throws Exception {
            this.outTuple.f0 = first;
            this.outTuple.f1 = second;
            return this.outTuple;
        }
    }

    public static class JoinedStream<I1, I2>
    extends SingleOutputStreamOperator<Tuple2<I1, I2>, JoinedStream<I1, I2>> {
        private final JoinPredicate<I1, I2> predicate;

        private JoinedStream(JoinPredicate<I1, I2> predicate, DataStream<Tuple2<I1, I2>> ds) {
            super(ds);
            this.predicate = predicate;
        }

        public <OUT> SingleOutputStreamOperator<OUT, ?> with(JoinFunction<I1, I2, OUT> joinFunction) {
            TypeInformation outType = TypeExtractor.getJoinReturnTypes(joinFunction, ((JoinPredicate)this.predicate).op.input1.getType(), ((JoinPredicate)this.predicate).op.input2.getType());
            CoWindowInvokable<I1, I2, OUT> invokable = new CoWindowInvokable<I1, I2, OUT>(StreamJoinOperator.getJoinWindowFunction(joinFunction, this.predicate), ((JoinPredicate)this.predicate).op.windowSize, ((JoinPredicate)this.predicate).op.slideInterval, ((JoinPredicate)this.predicate).op.timeStamp1, ((JoinPredicate)this.predicate).op.timeStamp2);
            this.jobGraphBuilder.setInvokable(this.id, invokable);
            return this.setType(outType);
        }
    }

    public static class JoinPredicate<I1, I2> {
        private StreamJoinOperator<I1, I2> op;
        private KeySelector<I1, ?> keys1;
        private KeySelector<I2, ?> keys2;
        private TypeInformation<I2> type2;

        private JoinPredicate(StreamJoinOperator<I1, I2> operator, KeySelector<I1, ?> keys1) {
            this.op = operator;
            this.keys1 = keys1;
            this.type2 = this.op.input2.getType();
        }

        public JoinedStream<I1, I2> equalTo(int ... fields) {
            this.keys2 = KeySelectorUtil.getSelectorForKeys(new Keys.ExpressionKeys(fields, this.type2), this.type2);
            return this.createJoinOperator();
        }

        public JoinedStream<I1, I2> equalTo(String ... fields) {
            this.keys2 = KeySelectorUtil.getSelectorForKeys(new Keys.ExpressionKeys(fields, this.type2), this.type2);
            return this.createJoinOperator();
        }

        public <K> JoinedStream<I1, I2> equalTo(KeySelector<I2, K> keySelector) {
            this.keys2 = keySelector;
            return this.createJoinOperator();
        }

        private JoinedStream<I1, I2> createJoinOperator() {
            DefaultJoinFunction joinFunction = new DefaultJoinFunction();
            JoinWindowFunction joinWindowFunction = StreamJoinOperator.getJoinWindowFunction(joinFunction, this);
            TupleTypeInfo outType = new TupleTypeInfo(new TypeInformation[]{this.op.input1.getType(), this.op.input2.getType()});
            return new JoinedStream(this, this.op.input1.groupBy(this.keys1).connect(this.op.input2.groupBy(this.keys2)).addGeneralWindowCombine(joinWindowFunction, outType, this.op.windowSize, this.op.slideInterval, this.op.timeStamp1, this.op.timeStamp2));
        }
    }

    public static class JoinWindow<I1, I2>
    implements TemporalWindow<JoinWindow<I1, I2>> {
        private StreamJoinOperator<I1, I2> op;
        private TypeInformation<I1> type1;

        private JoinWindow(StreamJoinOperator<I1, I2> operator) {
            this.op = operator;
            this.type1 = this.op.input1.getType();
        }

        public JoinPredicate<I1, I2> where(int ... fields) {
            return new JoinPredicate(this.op, KeySelectorUtil.getSelectorForKeys(new Keys.ExpressionKeys(fields, this.type1), this.type1));
        }

        public JoinPredicate<I1, I2> where(String ... fields) {
            return new JoinPredicate(this.op, KeySelectorUtil.getSelectorForKeys(new Keys.ExpressionKeys(fields, this.type1), this.type1));
        }

        public <K> JoinPredicate<I1, I2> where(KeySelector<I1, K> keySelector) {
            return new JoinPredicate(this.op, keySelector);
        }

        @Override
        public JoinWindow<I1, I2> every(long length, TimeUnit timeUnit) {
            return this.every(timeUnit.toMillis(length));
        }

        @Override
        public JoinWindow<I1, I2> every(long length) {
            this.op.slideInterval = length;
            return this;
        }
    }
}

