/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream.temporaloperator;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.temporaloperator.TemporalOperator;
import org.apache.flink.streaming.api.datastream.temporaloperator.TemporalWindow;
import org.apache.flink.streaming.api.function.co.CrossWindowFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoWindowInvokable;

public class StreamCrossOperator<I1, I2>
extends TemporalOperator<I1, I2, CrossWindow<I1, I2>> {
    public StreamCrossOperator(DataStream<I1> input1, DataStream<I2> input2) {
        super(input1, input2);
    }

    @Override
    protected CrossWindow<I1, I2> createNextWindowOperator() {
        CrossWindowFunction crossWindowFunction = new CrossWindowFunction((CrossFunction)this.input1.clean(new CrossOperator.DefaultCrossFunction()));
        return new CrossWindow(this, this.input1.connect(this.input2).addGeneralWindowCombine(crossWindowFunction, new TupleTypeInfo(new TypeInformation[]{this.input1.getType(), this.input2.getType()}), this.windowSize, this.slideInterval, this.timeStamp1, this.timeStamp2));
    }

    public static class CrossWindow<I1, I2>
    extends SingleOutputStreamOperator<Tuple2<I1, I2>, CrossWindow<I1, I2>>
    implements TemporalWindow<CrossWindow<I1, I2>> {
        private StreamCrossOperator<I1, I2> op;

        public CrossWindow(StreamCrossOperator<I1, I2> op, DataStream<Tuple2<I1, I2>> ds) {
            super(ds);
            this.op = op;
        }

        @Override
        public CrossWindow<I1, I2> every(long length, TimeUnit timeUnit) {
            return this.every(timeUnit.toMillis(length));
        }

        @Override
        public CrossWindow<I1, I2> every(long length) {
            ((CoWindowInvokable)this.jobGraphBuilder.getInvokable(this.id)).setSlideSize(length);
            return this;
        }

        public <R> SingleOutputStreamOperator<R, ?> with(CrossFunction<I1, I2, R> function) {
            TypeInformation outTypeInfo = TypeExtractor.getCrossReturnTypes(function, this.op.input1.getType(), this.op.input2.getType());
            CoWindowInvokable<I1, I2, R> invokable = new CoWindowInvokable<I1, I2, R>(new CrossWindowFunction<I1, I2, R>(this.clean(function)), this.op.windowSize, this.op.slideInterval, this.op.timeStamp1, this.op.timeStamp2);
            this.jobGraphBuilder.setInvokable(this.id, invokable);
            return this.setType(outTypeInfo);
        }
    }
}

