/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.GroupedDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.function.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.function.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.function.aggregation.SumAggregator;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.invokable.operator.GroupedWindowInvokable;
import org.apache.flink.streaming.api.invokable.operator.WindowGroupReduceInvokable;
import org.apache.flink.streaming.api.invokable.operator.WindowReduceInvokable;
import org.apache.flink.streaming.api.windowing.helper.Time;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.streaming.api.windowing.policy.CloneableEvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.CloneableTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TimeTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.TumblingEvictionPolicy;

public class WindowedDataStream<OUT> {
    protected DataStream<OUT> dataStream;
    protected boolean isGrouped;
    protected boolean allCentral;
    protected KeySelector<OUT, ?> keySelector;
    protected List<WindowingHelper<OUT>> triggerHelpers;
    protected List<WindowingHelper<OUT>> evictionHelpers;
    protected LinkedList<TriggerPolicy<OUT>> userTriggers;
    protected LinkedList<EvictionPolicy<OUT>> userEvicters;

    protected WindowedDataStream(DataStream<OUT> dataStream, WindowingHelper<OUT> ... policyHelpers) {
        this.dataStream = dataStream.copy();
        this.triggerHelpers = new ArrayList<WindowingHelper<OUT>>();
        for (WindowingHelper<OUT> helper : policyHelpers) {
            this.triggerHelpers.add(helper);
        }
        if (dataStream instanceof GroupedDataStream) {
            this.isGrouped = true;
            this.keySelector = ((GroupedDataStream)dataStream).keySelector;
            this.allCentral = false;
        } else {
            this.isGrouped = false;
            this.allCentral = true;
        }
    }

    protected WindowedDataStream(DataStream<OUT> dataStream, List<TriggerPolicy<OUT>> triggers, List<EvictionPolicy<OUT>> evicters) {
        this.dataStream = dataStream.copy();
        if (triggers != null) {
            this.userTriggers = new LinkedList();
            this.userTriggers.addAll(triggers);
        }
        if (evicters != null) {
            this.userEvicters = new LinkedList();
            this.userEvicters.addAll(evicters);
        }
        if (dataStream instanceof GroupedDataStream) {
            this.isGrouped = true;
            this.keySelector = ((GroupedDataStream)dataStream).keySelector;
            this.allCentral = false;
        } else {
            this.isGrouped = false;
            this.allCentral = true;
        }
    }

    protected WindowedDataStream(WindowedDataStream<OUT> windowedDataStream) {
        this.dataStream = windowedDataStream.dataStream.copy();
        this.isGrouped = windowedDataStream.isGrouped;
        this.keySelector = windowedDataStream.keySelector;
        this.triggerHelpers = windowedDataStream.triggerHelpers;
        this.evictionHelpers = windowedDataStream.evictionHelpers;
        this.userTriggers = windowedDataStream.userTriggers;
        this.userEvicters = windowedDataStream.userEvicters;
        this.allCentral = windowedDataStream.allCentral;
    }

    public <F> F clean(F f) {
        return this.dataStream.clean(f);
    }

    public WindowedDataStream<OUT> every(WindowingHelper ... policyHelpers) {
        WindowedDataStream<OUT> ret = this.copy();
        if (ret.evictionHelpers == null) {
            ret.evictionHelpers = ret.triggerHelpers;
            ret.triggerHelpers = new ArrayList<WindowingHelper<OUT>>();
        }
        for (WindowingHelper helper : policyHelpers) {
            ret.triggerHelpers.add(helper);
        }
        return ret;
    }

    public WindowedDataStream<OUT> groupBy(int ... fields) {
        WindowedDataStream<OUT> ret = this.copy();
        ret.dataStream = ret.dataStream.groupBy(fields);
        ret.isGrouped = true;
        ret.keySelector = ((GroupedDataStream)ret.dataStream).keySelector;
        return ret;
    }

    public WindowedDataStream<OUT> groupBy(String ... fields) {
        WindowedDataStream<OUT> ret = this.copy();
        ret.dataStream = ret.dataStream.groupBy(fields);
        ret.isGrouped = true;
        ret.keySelector = ((GroupedDataStream)ret.dataStream).keySelector;
        return ret;
    }

    public WindowedDataStream<OUT> groupBy(KeySelector<OUT, ?> keySelector) {
        WindowedDataStream<OUT> ret = this.copy();
        ret.dataStream = ret.dataStream.groupBy(keySelector);
        ret.isGrouped = true;
        ret.keySelector = ((GroupedDataStream)ret.dataStream).keySelector;
        return ret;
    }

    public SingleOutputStreamOperator<OUT, ?> reduce(ReduceFunction<OUT> reduceFunction) {
        return this.dataStream.transform("WindowReduce", this.getType(), this.getReduceInvokable(reduceFunction));
    }

    public <R> SingleOutputStreamOperator<R, ?> reduceGroup(GroupReduceFunction<OUT, R> reduceFunction) {
        TypeInformation<OUT> inType = this.getType();
        TypeInformation outType = TypeExtractor.getGroupReduceReturnTypes(reduceFunction, inType);
        return this.dataStream.transform("WindowReduce", outType, this.getReduceGroupInvokable(reduceFunction));
    }

    public <R> SingleOutputStreamOperator<R, ?> reduceGroup(GroupReduceFunction<OUT, R> reduceFunction, TypeInformation<R> outType) {
        return this.dataStream.transform("WindowReduce", outType, this.getReduceGroupInvokable(reduceFunction));
    }

    public SingleOutputStreamOperator<OUT, ?> sum(int positionToSum) {
        this.dataStream.checkFieldRange(positionToSum);
        return this.aggregate((AggregationFunction)SumAggregator.getSumFunction(positionToSum, this.dataStream.getClassAtPos(positionToSum), this.getType()));
    }

    public SingleOutputStreamOperator<OUT, ?> sum(String field) {
        return this.aggregate((AggregationFunction)SumAggregator.getSumFunction(field, this.getType()));
    }

    public SingleOutputStreamOperator<OUT, ?> min(int positionToMin) {
        this.dataStream.checkFieldRange(positionToMin);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMin, this.getType(), AggregationFunction.AggregationType.MIN));
    }

    public SingleOutputStreamOperator<OUT, ?> min(String field) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MIN, false));
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(int positionToMinBy, boolean first) {
        this.dataStream.checkFieldRange(positionToMinBy);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMinBy, this.getType(), AggregationFunction.AggregationType.MINBY, first));
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(String field, boolean first) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MINBY, first));
    }

    public SingleOutputStreamOperator<OUT, ?> max(int positionToMax) {
        this.dataStream.checkFieldRange(positionToMax);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMax, this.getType(), AggregationFunction.AggregationType.MAX));
    }

    public SingleOutputStreamOperator<OUT, ?> max(String field) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MAX, false));
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(int positionToMaxBy, boolean first) {
        this.dataStream.checkFieldRange(positionToMaxBy);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMaxBy, this.getType(), AggregationFunction.AggregationType.MAXBY, first));
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(String field, boolean first) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MAXBY, first));
    }

    private SingleOutputStreamOperator<OUT, ?> aggregate(AggregationFunction<OUT> aggregator) {
        StreamInvokable<OUT, OUT> invokable = this.getReduceInvokable(aggregator);
        SingleOutputStreamOperator<OUT, ?> returnStream = this.dataStream.transform("windowReduce", this.getType(), invokable);
        return returnStream;
    }

    private LinkedList<TriggerPolicy<OUT>> getTriggers() {
        LinkedList<TriggerPolicy<OUT>> triggers = new LinkedList<TriggerPolicy<OUT>>();
        if (this.triggerHelpers != null) {
            for (WindowingHelper<OUT> helper : this.triggerHelpers) {
                triggers.add(helper.toTrigger());
            }
        }
        if (this.userTriggers != null) {
            triggers.addAll(this.userTriggers);
        }
        return triggers;
    }

    private LinkedList<EvictionPolicy<OUT>> getEvicters() {
        LinkedList<EvictionPolicy<OUT>> evicters = new LinkedList<EvictionPolicy<OUT>>();
        if (this.evictionHelpers != null) {
            for (WindowingHelper<OUT> helper : this.evictionHelpers) {
                evicters.add(helper.toEvict());
            }
        } else if (this.userEvicters == null) {
            boolean notOnlyTime = false;
            for (WindowingHelper<OUT> helper : this.triggerHelpers) {
                if (helper instanceof Time) {
                    evicters.add(helper.toEvict());
                    continue;
                }
                notOnlyTime = true;
            }
            if (notOnlyTime) {
                evicters.add(new TumblingEvictionPolicy());
            }
        }
        if (this.userEvicters != null) {
            evicters.addAll(this.userEvicters);
        }
        return evicters;
    }

    private LinkedList<TriggerPolicy<OUT>> getCentralTriggers() {
        LinkedList<TriggerPolicy<OUT>> cTriggers = new LinkedList<TriggerPolicy<OUT>>();
        if (this.allCentral) {
            cTriggers.addAll(this.getTriggers());
        } else {
            for (TriggerPolicy triggerPolicy : this.getTriggers()) {
                if (!(triggerPolicy instanceof TimeTriggerPolicy)) continue;
                cTriggers.add(triggerPolicy);
            }
        }
        return cTriggers;
    }

    private LinkedList<CloneableTriggerPolicy<OUT>> getDistributedTriggers() {
        LinkedList<CloneableTriggerPolicy> dTriggers = null;
        if (!this.allCentral) {
            dTriggers = new LinkedList<CloneableTriggerPolicy>();
            for (TriggerPolicy triggerPolicy : this.getTriggers()) {
                if (triggerPolicy instanceof TimeTriggerPolicy) continue;
                dTriggers.add((CloneableTriggerPolicy)triggerPolicy);
            }
        }
        return dTriggers;
    }

    private LinkedList<CloneableEvictionPolicy<OUT>> getDistributedEvicters() {
        LinkedList<CloneableEvictionPolicy> evicters = null;
        if (!this.allCentral) {
            evicters = new LinkedList<CloneableEvictionPolicy>();
            for (EvictionPolicy evictionPolicy : this.getEvicters()) {
                evicters.add((CloneableEvictionPolicy)evictionPolicy);
            }
        }
        return evicters;
    }

    private LinkedList<EvictionPolicy<OUT>> getCentralEvicters() {
        if (this.allCentral) {
            return this.getEvicters();
        }
        return null;
    }

    private <R> StreamInvokable<OUT, R> getReduceGroupInvokable(GroupReduceFunction<OUT, R> reducer) {
        StreamInvokable invokable = this.isGrouped ? new GroupedWindowInvokable((Function)this.clean(reducer), this.keySelector, this.getDistributedTriggers(), this.getDistributedEvicters(), this.getCentralTriggers(), this.getCentralEvicters()) : new WindowGroupReduceInvokable<OUT, R>(this.clean(reducer), this.getTriggers(), this.getEvicters());
        return invokable;
    }

    private StreamInvokable<OUT, OUT> getReduceInvokable(ReduceFunction<OUT> reducer) {
        StreamInvokable invokable = this.isGrouped ? new GroupedWindowInvokable((Function)this.clean(reducer), this.keySelector, this.getDistributedTriggers(), this.getDistributedEvicters(), this.getCentralTriggers(), this.getCentralEvicters()) : new WindowReduceInvokable<OUT>(this.clean(reducer), this.getTriggers(), this.getEvicters());
        return invokable;
    }

    public TypeInformation<OUT> getType() {
        return this.dataStream.getType();
    }

    public DataStream<OUT> getDataStream() {
        return this.dataStream;
    }

    protected WindowedDataStream<OUT> copy() {
        return new WindowedDataStream<OUT>(this);
    }
}

