/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.collector.OutputSelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SplitDataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.state.OperatorState;

public class SingleOutputStreamOperator<OUT, O extends SingleOutputStreamOperator<OUT, O>>
extends DataStream<OUT> {
    protected SingleOutputStreamOperator(StreamExecutionEnvironment environment, String operatorType, TypeInformation<OUT> outTypeInfo) {
        super(environment, operatorType, outTypeInfo);
        this.setBufferTimeout(environment.getBufferTimeout());
    }

    protected SingleOutputStreamOperator(DataStream<OUT> dataStream) {
        super(dataStream);
    }

    public <R> SingleOutputStreamOperator<R, ?> setType(TypeInformation<R> outType) {
        this.jobGraphBuilder.setOutType(this.id, outType);
        this.typeInfo = outType;
        return this;
    }

    public SingleOutputStreamOperator<OUT, O> setParallelism(int dop) {
        if (dop < 1) {
            throw new IllegalArgumentException("The parallelism of an operator must be at least 1.");
        }
        this.degreeOfParallelism = dop;
        this.jobGraphBuilder.setParallelism(this.id, this.degreeOfParallelism);
        return this;
    }

    public SingleOutputStreamOperator<OUT, O> setBufferTimeout(long timeoutMillis) {
        this.jobGraphBuilder.setBufferTimeout(this.id, timeoutMillis);
        return this;
    }

    public SplitDataStream<OUT> split(OutputSelector<OUT> outputSelector) {
        try {
            this.jobGraphBuilder.setOutputSelector(this.id, SerializationUtils.serialize((Serializable)this.clean(outputSelector)));
        }
        catch (SerializationException e) {
            throw new RuntimeException("Cannot serialize OutputSelector");
        }
        return new SplitDataStream(this);
    }

    protected SingleOutputStreamOperator<OUT, O> registerState(String name, OperatorState<?> state) {
        this.jobGraphBuilder.addOperatorState(this.getId(), name, state);
        return this;
    }

    protected SingleOutputStreamOperator<OUT, O> registerState(Map<String, OperatorState<?>> states) {
        for (Map.Entry<String, OperatorState<?>> entry : states.entrySet()) {
            this.jobGraphBuilder.addOperatorState(this.getId(), entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SingleOutputStreamOperator<OUT, O> broadcast() {
        return (SingleOutputStreamOperator)super.broadcast();
    }

    public SingleOutputStreamOperator<OUT, O> shuffle() {
        return (SingleOutputStreamOperator)super.shuffle();
    }

    public SingleOutputStreamOperator<OUT, O> forward() {
        return (SingleOutputStreamOperator)super.forward();
    }

    public SingleOutputStreamOperator<OUT, O> distribute() {
        return (SingleOutputStreamOperator)super.distribute();
    }

    public SingleOutputStreamOperator<OUT, O> copy() {
        return new SingleOutputStreamOperator<OUT, O>(this);
    }
}

