/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;

public class IterativeDataStream<IN>
extends SingleOutputStreamOperator<IN, IterativeDataStream<IN>> {
    static Integer iterationCount = 0;
    protected Integer iterationID;
    protected long waitTime;

    protected IterativeDataStream(DataStream<IN> dataStream, long maxWaitTime) {
        super(dataStream);
        this.setBufferTimeout(dataStream.environment.getBufferTimeout());
        this.iterationID = iterationCount;
        Integer n = iterationCount;
        Integer n2 = iterationCount = Integer.valueOf(iterationCount + 1);
        this.waitTime = maxWaitTime;
    }

    protected IterativeDataStream(DataStream<IN> dataStream, Integer iterationID, long waitTime) {
        super(dataStream);
        this.iterationID = iterationID;
        this.waitTime = waitTime;
    }

    public DataStream<IN> closeWith(DataStream<IN> iterationTail) {
        DataStreamSink iterationSink = new DataStreamSink(this.environment, "iterationSink", null);
        this.jobGraphBuilder.addIterationTail(iterationSink.getId(), iterationTail.getId(), this.iterationID, iterationTail.getParallelism(), this.waitTime);
        this.jobGraphBuilder.setIterationSourceSettings(this.iterationID.toString(), iterationTail.getId());
        this.connectGraph(iterationTail, iterationSink.getId(), 0);
        return iterationTail;
    }

    @Override
    public IterativeDataStream<IN> copy() {
        return new IterativeDataStream<IN>(this, this.iterationID, this.waitTime);
    }
}

