/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.JobGraphBuilder;
import org.apache.flink.streaming.api.datastream.ConnectedDataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.GroupedDataStream;
import org.apache.flink.streaming.api.datastream.IterativeDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.StreamProjection;
import org.apache.flink.streaming.api.datastream.WindowedDataStream;
import org.apache.flink.streaming.api.datastream.temporaloperator.StreamCrossOperator;
import org.apache.flink.streaming.api.datastream.temporaloperator.StreamJoinOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.function.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.function.aggregation.SumAggregator;
import org.apache.flink.streaming.api.function.sink.PrintSinkFunction;
import org.apache.flink.streaming.api.function.sink.SinkFunction;
import org.apache.flink.streaming.api.function.sink.WriteFormat;
import org.apache.flink.streaming.api.function.sink.WriteFormatAsCsv;
import org.apache.flink.streaming.api.function.sink.WriteFormatAsText;
import org.apache.flink.streaming.api.function.sink.WriteSinkFunctionByMillis;
import org.apache.flink.streaming.api.invokable.SinkInvokable;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.invokable.operator.CounterInvokable;
import org.apache.flink.streaming.api.invokable.operator.FilterInvokable;
import org.apache.flink.streaming.api.invokable.operator.FlatMapInvokable;
import org.apache.flink.streaming.api.invokable.operator.MapInvokable;
import org.apache.flink.streaming.api.invokable.operator.StreamReduceInvokable;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.streaming.api.windowing.policy.EvictionPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;
import org.apache.flink.streaming.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.partitioner.DistributePartitioner;
import org.apache.flink.streaming.partitioner.FieldsPartitioner;
import org.apache.flink.streaming.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.partitioner.StreamPartitioner;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;

public class DataStream<OUT> {
    protected static Integer counter = 0;
    protected final StreamExecutionEnvironment environment;
    protected final String id;
    protected int degreeOfParallelism;
    protected List<String> userDefinedNames;
    protected boolean selectAll;
    protected StreamPartitioner<OUT> partitioner;
    protected TypeInformation typeInfo;
    protected List<DataStream<OUT>> mergedStreams;
    protected final JobGraphBuilder jobGraphBuilder;

    public DataStream(StreamExecutionEnvironment environment, String operatorType, TypeInformation<OUT> typeInfo) {
        if (environment == null) {
            throw new NullPointerException("context is null");
        }
        Integer n = counter;
        Integer n2 = counter = Integer.valueOf(counter + 1);
        this.id = operatorType + "-" + counter.toString();
        this.environment = environment;
        this.degreeOfParallelism = environment.getDegreeOfParallelism();
        this.jobGraphBuilder = environment.getJobGraphBuilder();
        this.userDefinedNames = new ArrayList<String>();
        this.selectAll = false;
        this.partitioner = new DistributePartitioner<OUT>(true);
        this.typeInfo = typeInfo;
        this.mergedStreams = new ArrayList<DataStream<OUT>>();
        this.mergedStreams.add(this);
    }

    public DataStream(DataStream<OUT> dataStream) {
        this.environment = dataStream.environment;
        this.id = dataStream.id;
        this.degreeOfParallelism = dataStream.degreeOfParallelism;
        this.userDefinedNames = new ArrayList<String>(dataStream.userDefinedNames);
        this.selectAll = dataStream.selectAll;
        this.partitioner = dataStream.partitioner;
        this.jobGraphBuilder = dataStream.jobGraphBuilder;
        this.typeInfo = dataStream.typeInfo;
        this.mergedStreams = new ArrayList<DataStream<OUT>>();
        this.mergedStreams.add(this);
        if (dataStream.mergedStreams.size() > 1) {
            for (int i = 1; i < dataStream.mergedStreams.size(); ++i) {
                this.mergedStreams.add(new DataStream<OUT>(dataStream.mergedStreams.get(i)));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public int getParallelism() {
        return this.degreeOfParallelism;
    }

    public TypeInformation<OUT> getType() {
        return this.typeInfo;
    }

    public <R> DataStream<R> setType(TypeInformation<R> outType) {
        this.jobGraphBuilder.setOutType(this.id, outType);
        this.typeInfo = outType;
        return this;
    }

    public <F> F clean(F f) {
        if (this.getExecutionEnvironment().getConfig().isClosureCleanerEnabled()) {
            ClosureCleaner.clean(f, (boolean)true);
        }
        ClosureCleaner.ensureSerializable(f);
        return f;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public DataStream<OUT> merge(DataStream<OUT> ... streams) {
        DataStream<OUT> returnStream = this.copy();
        for (DataStream<OUT> stream : streams) {
            for (DataStream<OUT> ds : stream.mergedStreams) {
                this.validateMerge(ds.getId());
                returnStream.mergedStreams.add(ds.copy());
            }
        }
        return returnStream;
    }

    public <R> ConnectedDataStream<OUT, R> connect(DataStream<R> dataStream) {
        return new ConnectedDataStream(this, dataStream);
    }

    public GroupedDataStream<OUT> groupBy(int ... fields) {
        if (this.getType() instanceof BasicArrayTypeInfo || this.getType() instanceof PrimitiveArrayTypeInfo) {
            return this.groupBy(new KeySelectorUtil.ArrayKeySelector(fields));
        }
        return this.groupBy((Keys<OUT>)new Keys.ExpressionKeys(fields, this.getType()));
    }

    public GroupedDataStream<OUT> groupBy(String ... fields) {
        return this.groupBy((Keys<OUT>)new Keys.ExpressionKeys(fields, this.getType()));
    }

    public GroupedDataStream<OUT> groupBy(KeySelector<OUT, ?> keySelector) {
        return new GroupedDataStream<OUT>(this, this.clean(keySelector));
    }

    private GroupedDataStream<OUT> groupBy(Keys<OUT> keys) {
        return new GroupedDataStream<OUT>(this, this.clean(KeySelectorUtil.getSelectorForKeys(keys, this.getType())));
    }

    protected DataStream<OUT> partitionBy(KeySelector<OUT, ?> keySelector) {
        return this.setConnectionType(new FieldsPartitioner<OUT>(this.clean(keySelector)));
    }

    public DataStream<OUT> broadcast() {
        return this.setConnectionType(new BroadcastPartitioner());
    }

    public DataStream<OUT> shuffle() {
        return this.setConnectionType(new ShufflePartitioner());
    }

    public DataStream<OUT> forward() {
        return this.setConnectionType(new DistributePartitioner(true));
    }

    public DataStream<OUT> distribute() {
        return this.setConnectionType(new DistributePartitioner(false));
    }

    public DataStream<OUT> global() {
        return this.setConnectionType(new GlobalPartitioner());
    }

    public IterativeDataStream<OUT> iterate() {
        return new IterativeDataStream(this, 0L);
    }

    public IterativeDataStream<OUT> iterate(long maxWaitTimeMillis) {
        return new IterativeDataStream(this, maxWaitTimeMillis);
    }

    public <R> SingleOutputStreamOperator<R, ?> map(MapFunction<OUT, R> mapper) {
        TypeInformation outType = TypeExtractor.getMapReturnTypes(this.clean(mapper), this.getType());
        return this.transform("map", outType, new MapInvokable<OUT, R>(this.clean(mapper)));
    }

    public <R> SingleOutputStreamOperator<R, ?> flatMap(FlatMapFunction<OUT, R> flatMapper) {
        TypeInformation outType = TypeExtractor.getFlatMapReturnTypes(this.clean(flatMapper), this.getType());
        return this.transform("flatMap", outType, new FlatMapInvokable<OUT, R>(this.clean(flatMapper)));
    }

    public SingleOutputStreamOperator<OUT, ?> reduce(ReduceFunction<OUT> reducer) {
        return this.transform("reduce", this.getType(), new StreamReduceInvokable<OUT>(this.clean(reducer)));
    }

    public SingleOutputStreamOperator<OUT, ?> filter(FilterFunction<OUT> filter) {
        return this.transform("filter", this.getType(), new FilterInvokable<OUT>(this.clean(filter)));
    }

    public StreamProjection<OUT> project(int ... fieldIndexes) {
        return new StreamProjection<OUT>(this.copy(), fieldIndexes);
    }

    public <IN2> StreamCrossOperator<OUT, IN2> cross(DataStream<IN2> dataStreamToCross) {
        return new StreamCrossOperator(this, dataStreamToCross);
    }

    public <IN2> StreamJoinOperator<OUT, IN2> join(DataStream<IN2> dataStreamToJoin) {
        return new StreamJoinOperator(this, dataStreamToJoin);
    }

    public SingleOutputStreamOperator<OUT, ?> sum(int positionToSum) {
        this.checkFieldRange(positionToSum);
        return this.aggregate((AggregationFunction)SumAggregator.getSumFunction(positionToSum, this.getClassAtPos(positionToSum), this.getType()));
    }

    public SingleOutputStreamOperator<OUT, ?> sum(String field) {
        return this.aggregate((AggregationFunction)SumAggregator.getSumFunction(field, this.getType()));
    }

    public SingleOutputStreamOperator<OUT, ?> min(int positionToMin) {
        this.checkFieldRange(positionToMin);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMin, this.getType(), AggregationFunction.AggregationType.MIN));
    }

    public SingleOutputStreamOperator<OUT, ?> min(String field) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MIN, false));
    }

    public SingleOutputStreamOperator<OUT, ?> max(int positionToMax) {
        this.checkFieldRange(positionToMax);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMax, this.getType(), AggregationFunction.AggregationType.MAX));
    }

    public SingleOutputStreamOperator<OUT, ?> max(String field) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MAX, false));
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(String field, boolean first) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MINBY, first));
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(String field, boolean first) {
        return this.aggregate(ComparableAggregator.getAggregator(field, this.getType(), AggregationFunction.AggregationType.MAXBY, first));
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> minBy(int positionToMinBy, boolean first) {
        this.checkFieldRange(positionToMinBy);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMinBy, this.getType(), AggregationFunction.AggregationType.MINBY, first));
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<OUT, ?> maxBy(int positionToMaxBy, boolean first) {
        this.checkFieldRange(positionToMaxBy);
        return this.aggregate(ComparableAggregator.getAggregator(positionToMaxBy, this.getType(), AggregationFunction.AggregationType.MAXBY, first));
    }

    public SingleOutputStreamOperator<Long, ?> count() {
        TypeInformation outTypeInfo = TypeExtractor.getForObject((Object)0L);
        return this.transform("counter", outTypeInfo, new CounterInvokable());
    }

    public WindowedDataStream<OUT> window(WindowingHelper ... policyHelpers) {
        return new WindowedDataStream(this, policyHelpers);
    }

    public WindowedDataStream<OUT> window(List<TriggerPolicy<OUT>> triggers, List<EvictionPolicy<OUT>> evicters) {
        return new WindowedDataStream<OUT>(this, triggers, evicters);
    }

    public DataStreamSink<OUT> print() {
        PrintSinkFunction printFunction = new PrintSinkFunction();
        DataStreamSink returnStream = this.addSink(printFunction);
        return returnStream;
    }

    public DataStreamSink<OUT> printToErr() {
        PrintSinkFunction printFunction = new PrintSinkFunction(true);
        DataStreamSink returnStream = this.addSink(printFunction);
        return returnStream;
    }

    public DataStreamSink<OUT> writeAsText(String path, long millis) {
        return this.writeAsText(path, new WriteFormatAsText(), millis);
    }

    public DataStreamSink<OUT> writeAsText(String path) {
        return this.writeAsText(path, 0L);
    }

    public DataStreamSink<OUT> writeAsCsv(String path, long millis) {
        if (!this.getType().isTupleType()) {
            throw new RuntimeException("Only tuple data streams can be written in csv format");
        }
        return this.writeAsText(path, new WriteFormatAsCsv(), millis);
    }

    public DataStreamSink<OUT> writeAsCsv(String path) {
        return this.writeAsCsv(path, 0L);
    }

    private DataStreamSink<OUT> writeAsText(String path, WriteFormat<OUT> format, long millis) {
        DataStreamSink<OUT> returnStream = this.addSink(new WriteSinkFunctionByMillis<OUT>(path, format, millis));
        return returnStream;
    }

    protected SingleOutputStreamOperator<OUT, ?> aggregate(AggregationFunction<OUT> aggregate) {
        StreamReduceInvokable<OUT> invokable = new StreamReduceInvokable<OUT>(aggregate);
        SingleOutputStreamOperator<OUT, ?> returnStream = this.transform("reduce", this.getType(), invokable);
        return returnStream;
    }

    protected <R> DataStream<OUT> addIterationSource(Integer iterationID, long waitTime) {
        DataStreamSource returnStream = new DataStreamSource(this.environment, "iterationSource", null, true);
        this.jobGraphBuilder.addIterationHead(returnStream.getId(), this.getId(), iterationID, this.degreeOfParallelism, waitTime);
        return this.copy();
    }

    public <R> SingleOutputStreamOperator<R, ?> transform(String operatorName, TypeInformation<R> outTypeInfo, StreamInvokable<OUT, R> invokable) {
        DataStream<OUT> inputStream = this.copy();
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, operatorName, outTypeInfo);
        this.jobGraphBuilder.addStreamVertex(returnStream.getId(), invokable, this.getType(), outTypeInfo, operatorName, this.degreeOfParallelism);
        this.connectGraph(inputStream, returnStream.getId(), 0);
        if (inputStream instanceof IterativeDataStream) {
            IterativeDataStream iterativeStream = (IterativeDataStream)inputStream;
            returnStream.addIterationSource(iterativeStream.iterationID, iterativeStream.waitTime);
        }
        return returnStream;
    }

    protected DataStream<OUT> setConnectionType(StreamPartitioner<OUT> partitioner) {
        DataStream<OUT> returnStream = this.copy();
        for (DataStream<OUT> stream : returnStream.mergedStreams) {
            stream.partitioner = partitioner;
        }
        return returnStream;
    }

    protected <X> void connectGraph(DataStream<X> inputStream, String outputID, int typeNumber) {
        for (DataStream<OUT> stream : inputStream.mergedStreams) {
            this.jobGraphBuilder.setEdge(stream.getId(), outputID, stream.partitioner, typeNumber, inputStream.userDefinedNames, inputStream.selectAll);
        }
    }

    public DataStreamSink<OUT> addSink(SinkFunction<OUT> sinkFunction) {
        DataStreamSink<OUT> returnStream = new DataStreamSink<OUT>(this.environment, "sink", this.getType());
        this.jobGraphBuilder.addStreamVertex(returnStream.getId(), new SinkInvokable<OUT>(this.clean(sinkFunction)), this.getType(), null, "sink", this.degreeOfParallelism);
        this.connectGraph(this.copy(), returnStream.getId(), 0);
        return returnStream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Class<?> getClassAtPos(int pos) {
        void var3_14;
        TypeInformation<OUT> outTypeInfo = this.getType();
        if (outTypeInfo.isTupleType()) {
            Class clazz = ((TupleTypeInfo)outTypeInfo).getTypeAt(pos).getTypeClass();
            return var3_14;
        } else if (outTypeInfo instanceof BasicArrayTypeInfo) {
            Class clazz = ((BasicArrayTypeInfo)outTypeInfo).getComponentTypeClass();
            return var3_14;
        } else {
            if (outTypeInfo instanceof PrimitiveArrayTypeInfo) {
                Class clazz = outTypeInfo.getTypeClass();
                if (clazz == boolean[].class) {
                    return var3_14;
                }
                if (clazz == short[].class) {
                    return var3_14;
                }
                if (clazz == int[].class) {
                    return var3_14;
                }
                if (clazz == long[].class) {
                    return var3_14;
                }
                if (clazz == float[].class) {
                    return var3_14;
                }
                if (clazz == double[].class) {
                    return var3_14;
                }
                if (clazz != char[].class) throw new IndexOutOfBoundsException("Type could not be determined for array");
                return var3_14;
            }
            if (pos != 0) throw new IndexOutOfBoundsException("Position is out of range");
            Class clazz = outTypeInfo.getTypeClass();
        }
        return var3_14;
    }

    protected void checkFieldRange(int pos) {
        try {
            this.getClassAtPos(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Selected field is out of range");
        }
    }

    private void validateMerge(String id) {
        for (DataStream<OUT> ds : this.mergedStreams) {
            if (!ds.getId().equals(id)) continue;
            throw new RuntimeException("A DataStream cannot be merged with itself");
        }
    }

    public DataStream<OUT> copy() {
        return new DataStream<OUT>(this);
    }
}

