/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.collector;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.collector.OutputSelector;
import org.apache.flink.streaming.api.collector.StreamCollector;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectedStreamCollector<OUT>
extends StreamCollector<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(DirectedStreamCollector.class);
    OutputSelector<OUT> outputSelector;
    private List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> selectAllOutputs;
    private Set<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> emitted;

    public DirectedStreamCollector(int channelID, SerializationDelegate<StreamRecord<OUT>> serializationDelegate, OutputSelector<OUT> outputSelector) {
        super(channelID, serializationDelegate);
        this.outputSelector = outputSelector;
        this.emitted = new HashSet<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>();
        this.selectAllOutputs = new LinkedList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>();
    }

    @Override
    public void addOutput(RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output, List<String> outputNames, boolean isSelectAllOutput) {
        if (isSelectAllOutput) {
            this.selectAllOutputs.add(output);
        } else {
            this.addOneOutput(output, outputNames, isSelectAllOutput);
        }
    }

    @Override
    protected void emitToOutputs() {
        Iterable<String> outputNames = this.outputSelector.select(this.streamRecord.getObject());
        this.emitted.clear();
        for (RecordWriter<SerializationDelegate<StreamRecord<OUT>>> output : this.selectAllOutputs) {
            try {
                output.emit((IOReadableWritable)this.serializationDelegate);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Emit to {} failed due to: {}", output, (Object)StringUtils.stringifyException((Throwable)e));
            }
        }
        this.emitted.addAll(this.selectAllOutputs);
        for (String outputName : outputNames) {
            List outputList = (List)this.outputMap.get(outputName);
            try {
                if (outputList == null) {
                    if (!LOG.isErrorEnabled()) continue;
                    String format = String.format("Cannot emit because no output is selected with the name: %s", outputName);
                    LOG.error(format);
                    continue;
                }
                for (RecordWriter output : outputList) {
                    if (this.emitted.contains(output)) continue;
                    output.emit((IOReadableWritable)this.serializationDelegate);
                    this.emitted.add(output);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Emit to {} failed due to: {}", (Object)outputName, (Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }
}

