/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.streaming.api.StreamConfig;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.api.invokable.SourceInvokable;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.invokable.operator.co.CoInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.CoStreamVertex;
import org.apache.flink.streaming.api.streamvertex.StreamIterationHead;
import org.apache.flink.streaming.api.streamvertex.StreamIterationTail;
import org.apache.flink.streaming.api.streamvertex.StreamVertex;
import org.apache.flink.streaming.partitioner.StreamPartitioner;
import org.apache.flink.streaming.state.OperatorState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobGraphBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JobGraphBuilder.class);
    private static final String DEAFULT_JOB_NAME = "Streaming Job";
    private JobGraph jobGraph;
    private Map<String, AbstractJobVertex> streamVertices = new HashMap<String, AbstractJobVertex>();
    private Map<String, Integer> vertexParallelism = new HashMap<String, Integer>();
    private Map<String, Long> bufferTimeout = new HashMap<String, Long>();
    private Map<String, List<String>> outEdgeList = new HashMap<String, List<String>>();
    private Map<String, List<Integer>> outEdgeType = new HashMap<String, List<Integer>>();
    private Map<String, List<List<String>>> outEdgeNames = new HashMap<String, List<List<String>>>();
    private Map<String, List<Boolean>> outEdgeSelectAll = new HashMap<String, List<Boolean>>();
    private Map<String, List<String>> inEdgeList = new HashMap<String, List<String>>();
    private Map<String, List<StreamPartitioner<?>>> connectionTypes = new HashMap();
    private Map<String, String> operatorNames = new HashMap<String, String>();
    private Map<String, StreamInvokable<?, ?>> invokableObjects = new HashMap();
    private Map<String, StreamRecordSerializer<?>> typeSerializersIn1 = new HashMap();
    private Map<String, StreamRecordSerializer<?>> typeSerializersIn2 = new HashMap();
    private Map<String, StreamRecordSerializer<?>> typeSerializersOut1 = new HashMap();
    private Map<String, StreamRecordSerializer<?>> typeSerializersOut2 = new HashMap();
    private Map<String, byte[]> outputSelectors = new HashMap<String, byte[]>();
    private Map<String, Class<? extends AbstractInvokable>> vertexClasses = new HashMap<String, Class<? extends AbstractInvokable>>();
    private Map<String, Integer> iterationIds = new HashMap<String, Integer>();
    private Map<Integer, String> iterationIDtoHeadName = new HashMap<Integer, String>();
    private Map<Integer, String> iterationIDtoTailName = new HashMap<Integer, String>();
    private Map<String, Integer> iterationTailCount = new HashMap<String, Integer>();
    private Map<String, Long> iterationWaitTime = new HashMap<String, Long>();
    private Map<String, Map<String, OperatorState<?>>> operatorStates = new HashMap();
    private Map<String, InputFormat<String, ?>> inputFormatList = new HashMap();

    public JobGraphBuilder() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("JobGraph created");
        }
    }

    public <IN, OUT> void addStreamVertex(String vertexName, StreamInvokable<IN, OUT> invokableObject, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName, int parallelism) {
        this.addVertex(vertexName, StreamVertex.class, invokableObject, operatorName, parallelism);
        StreamRecordSerializer<IN> inSerializer = inTypeInfo != null ? new StreamRecordSerializer<IN>(inTypeInfo) : null;
        StreamRecordSerializer<OUT> outSerializer = outTypeInfo != null ? new StreamRecordSerializer<OUT>(outTypeInfo) : null;
        this.addTypeSerializers(vertexName, inSerializer, null, outSerializer, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vertex: {}", (Object)vertexName);
        }
    }

    public <IN, OUT> void addSourceVertex(String vertexName, SourceFunction<OUT> function, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName, byte[] serializedFunction, int parallelism) {
        SourceInvokable<OUT> invokableObject = new SourceInvokable<OUT>(function);
        this.addStreamVertex(vertexName, invokableObject, inTypeInfo, outTypeInfo, operatorName, parallelism);
    }

    public void addIterationHead(String vertexName, String iterationHead, Integer iterationID, int parallelism, long waitTime) {
        this.addVertex(vertexName, StreamIterationHead.class, null, null, parallelism);
        this.iterationIds.put(vertexName, iterationID);
        this.iterationIDtoHeadName.put(iterationID, vertexName);
        this.setBytesFrom(iterationHead, vertexName);
        this.setEdge(vertexName, iterationHead, this.connectionTypes.get(this.inEdgeList.get(iterationHead).get(0)).get(0), 0, new ArrayList<String>(), false);
        this.iterationWaitTime.put(this.iterationIDtoHeadName.get(iterationID), waitTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ITERATION SOURCE: {}", (Object)vertexName);
        }
    }

    public void addIterationTail(String vertexName, String iterationTail, Integer iterationID, int parallelism, long waitTime) {
        if (this.bufferTimeout.get(iterationTail) == 0L) {
            throw new RuntimeException("Buffer timeout 0 at iteration tail is not supported.");
        }
        this.addVertex(vertexName, StreamIterationTail.class, null, null, parallelism);
        this.iterationIds.put(vertexName, iterationID);
        this.iterationIDtoTailName.put(iterationID, vertexName);
        this.setBytesFrom(iterationTail, vertexName);
        this.iterationWaitTime.put(this.iterationIDtoTailName.get(iterationID), waitTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ITERATION SINK: {}", (Object)vertexName);
        }
    }

    public <IN1, IN2, OUT> void addCoTask(String vertexName, CoInvokable<IN1, IN2, OUT> taskInvokableObject, TypeInformation<IN1> in1TypeInfo, TypeInformation<IN2> in2TypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName, int parallelism) {
        this.addVertex(vertexName, CoStreamVertex.class, taskInvokableObject, operatorName, parallelism);
        this.addTypeSerializers(vertexName, new StreamRecordSerializer<IN1>(in1TypeInfo), new StreamRecordSerializer<IN2>(in2TypeInfo), new StreamRecordSerializer<OUT>(outTypeInfo), null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CO-TASK: {}", (Object)vertexName);
        }
    }

    private void addVertex(String vertexName, Class<? extends AbstractInvokable> vertexClass, StreamInvokable<?, ?> invokableObject, String operatorName, int parallelism) {
        this.vertexClasses.put(vertexName, vertexClass);
        this.setParallelism(vertexName, parallelism);
        this.invokableObjects.put(vertexName, invokableObject);
        this.operatorNames.put(vertexName, operatorName);
        this.outEdgeList.put(vertexName, new ArrayList());
        this.outEdgeType.put(vertexName, new ArrayList());
        this.outEdgeNames.put(vertexName, new ArrayList());
        this.outEdgeSelectAll.put(vertexName, new ArrayList());
        this.inEdgeList.put(vertexName, new ArrayList());
        this.connectionTypes.put(vertexName, new ArrayList());
        this.iterationTailCount.put(vertexName, 0);
    }

    private void addTypeSerializers(String vertexName, StreamRecordSerializer<?> in1, StreamRecordSerializer<?> in2, StreamRecordSerializer<?> out1, StreamRecordSerializer<?> out2) {
        this.typeSerializersIn1.put(vertexName, in1);
        this.typeSerializersIn2.put(vertexName, in2);
        this.typeSerializersOut1.put(vertexName, out1);
        this.typeSerializersOut2.put(vertexName, out2);
    }

    private void createVertex(String vertexName) {
        Class<? extends AbstractInvokable> vertexClass = this.vertexClasses.get(vertexName);
        StreamInvokable<?, ?> invokableObject = this.invokableObjects.get(vertexName);
        int parallelism = this.vertexParallelism.get(vertexName);
        byte[] outputSelector = this.outputSelectors.get(vertexName);
        Map<String, OperatorState<?>> state = this.operatorStates.get(vertexName);
        AbstractJobVertex vertex = new AbstractJobVertex(vertexName);
        this.jobGraph.addVertex(vertex);
        vertex.setInvokableClass(vertexClass);
        vertex.setParallelism(parallelism);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parallelism set: {} for {}", (Object)parallelism, (Object)vertexName);
        }
        StreamConfig config = new StreamConfig(vertex.getConfiguration());
        config.setBufferTimeout(this.bufferTimeout.get(vertexName));
        config.setTypeSerializerIn1(this.typeSerializersIn1.get(vertexName));
        config.setTypeSerializerIn2(this.typeSerializersIn2.get(vertexName));
        config.setTypeSerializerOut1(this.typeSerializersOut1.get(vertexName));
        config.setTypeSerializerOut2(this.typeSerializersOut2.get(vertexName));
        config.setUserInvokable(invokableObject);
        config.setVertexName(vertexName);
        config.setOutputSelector(outputSelector);
        config.setOperatorStates(state);
        if (vertexClass.equals(StreamIterationHead.class) || vertexClass.equals(StreamIterationTail.class)) {
            config.setIterationId(this.iterationIds.get(vertexName));
            config.setIterationWaitTime(this.iterationWaitTime.get(vertexName));
        }
        if (this.inputFormatList.containsKey(vertexName)) {
            vertex.setInputSplitSource((InputSplitSource)this.inputFormatList.get(vertexName));
        }
        this.streamVertices.put(vertexName, vertex);
    }

    private <T> void connect(String upStreamVertexName, String downStreamVertexName, StreamPartitioner<T> partitionerObject) {
        AbstractJobVertex upStreamVertex = this.streamVertices.get(upStreamVertexName);
        AbstractJobVertex downStreamVertex = this.streamVertices.get(downStreamVertexName);
        StreamConfig config = new StreamConfig(upStreamVertex.getConfiguration());
        if (partitionerObject.getStrategy() == StreamPartitioner.PartitioningStrategy.FORWARD) {
            downStreamVertex.connectNewDataSetAsInput(upStreamVertex, DistributionPattern.POINTWISE);
        } else {
            downStreamVertex.connectNewDataSetAsInput(upStreamVertex, DistributionPattern.BIPARTITE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CONNECTED: {} - {} -> {}", new Object[]{partitionerObject.getClass().getSimpleName(), upStreamVertexName, downStreamVertexName});
        }
        int outputIndex = upStreamVertex.getNumberOfProducedIntermediateDataSets() - 1;
        config.setOutputName(outputIndex, this.outEdgeNames.get(upStreamVertexName).get(outputIndex));
        config.setSelectAll(outputIndex, this.outEdgeSelectAll.get(upStreamVertexName).get(outputIndex));
        config.setPartitioner(outputIndex, partitionerObject);
        config.setNumberOfOutputChannels(outputIndex, this.vertexParallelism.get(downStreamVertexName));
    }

    public void setParallelism(String vertexName, int parallelism) {
        this.vertexParallelism.put(vertexName, parallelism);
    }

    public void setInputFormat(String vertexName, InputFormat<String, ?> inputFormat) {
        this.inputFormatList.put(vertexName, inputFormat);
    }

    public void setBufferTimeout(String vertexName, long bufferTimeout) {
        this.bufferTimeout.put(vertexName, bufferTimeout);
    }

    public void addOperatorState(String veretxName, String stateName, OperatorState<?> state) {
        Map<String, OperatorState<?>> states = this.operatorStates.get(veretxName);
        if (states == null) {
            states = new HashMap();
            states.put(stateName, state);
        } else {
            if (states.containsKey(stateName)) {
                throw new RuntimeException("State has already been registered with this name: " + stateName);
            }
            states.put(stateName, state);
        }
        this.operatorStates.put(veretxName, states);
    }

    public void setEdge(String upStreamVertexName, String downStreamVertexName, StreamPartitioner<?> partitionerObject, int typeNumber, List<String> outputNames, boolean selectAll) {
        this.outEdgeList.get(upStreamVertexName).add(downStreamVertexName);
        this.outEdgeType.get(upStreamVertexName).add(typeNumber);
        this.inEdgeList.get(downStreamVertexName).add(upStreamVertexName);
        this.connectionTypes.get(upStreamVertexName).add(partitionerObject);
        this.outEdgeNames.get(upStreamVertexName).add(outputNames);
        this.outEdgeSelectAll.get(upStreamVertexName).add(selectAll);
    }

    public void setIterationSourceSettings(String iterationID, String iterationTail) {
        this.setParallelism(this.iterationIDtoHeadName.get(iterationID), this.vertexParallelism.get(iterationTail));
        this.setBufferTimeout(this.iterationIDtoHeadName.get(iterationID), this.bufferTimeout.get(iterationTail));
    }

    public <T> void setOutputSelector(String vertexName, byte[] serializedOutputSelector) {
        this.outputSelectors.put(vertexName, serializedOutputSelector);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Outputselector set for {}", (Object)vertexName);
        }
    }

    public <IN, OUT> void setInvokable(String id, StreamInvokable<IN, OUT> invokableObject) {
        this.invokableObjects.put(id, invokableObject);
    }

    public StreamInvokable<?, ?> getInvokable(String id) {
        return this.invokableObjects.get(id);
    }

    public <OUT> void setOutType(String id, TypeInformation<OUT> outType) {
        StreamRecordSerializer<OUT> serializer = new StreamRecordSerializer<OUT>(outType);
        this.typeSerializersOut1.put(id, serializer);
    }

    public void setBytesFrom(String from, String to) {
        this.operatorNames.put(to, this.operatorNames.get(from));
        this.typeSerializersIn1.put(to, this.typeSerializersOut1.get(from));
        this.typeSerializersIn2.put(to, this.typeSerializersOut2.get(from));
        this.typeSerializersOut1.put(to, this.typeSerializersOut1.get(from));
        this.typeSerializersOut2.put(to, this.typeSerializersOut2.get(from));
    }

    private void setSlotSharing() {
        SlotSharingGroup shareGroup = new SlotSharingGroup();
        for (AbstractJobVertex vertex : this.streamVertices.values()) {
            vertex.setSlotSharingGroup(shareGroup);
        }
        for (Integer iterID : new HashSet<Integer>(this.iterationIds.values())) {
            CoLocationGroup ccg = new CoLocationGroup();
            AbstractJobVertex tail = this.streamVertices.get(this.iterationIDtoTailName.get(iterID));
            AbstractJobVertex head = this.streamVertices.get(this.iterationIDtoHeadName.get(iterID));
            ccg.addVertex(head);
            ccg.addVertex(tail);
        }
    }

    private void setNumberOfJobInputs() {
        for (AbstractJobVertex vertex : this.streamVertices.values()) {
            new StreamConfig(vertex.getConfiguration()).setNumberOfInputs(vertex.getNumberOfInputs());
        }
    }

    private void setNumberOfJobOutputs() {
        for (AbstractJobVertex vertex : this.streamVertices.values()) {
            new StreamConfig(vertex.getConfiguration()).setNumberOfOutputs(vertex.getNumberOfProducedIntermediateDataSets());
        }
    }

    public JobGraph getJobGraph() {
        return this.getJobGraph(DEAFULT_JOB_NAME);
    }

    public JobGraph getJobGraph(String jobGraphName) {
        this.jobGraph = new JobGraph(jobGraphName);
        this.buildJobGraph();
        return this.jobGraph;
    }

    private void buildJobGraph() {
        for (String vertexName : this.outEdgeList.keySet()) {
            this.createVertex(vertexName);
        }
        for (String upStreamVertexName : this.outEdgeList.keySet()) {
            int i = 0;
            List<Integer> outEdgeTypeList = this.outEdgeType.get(upStreamVertexName);
            for (String downStreamVertexName : this.outEdgeList.get(upStreamVertexName)) {
                StreamConfig downStreamVertexConfig = new StreamConfig(this.streamVertices.get(downStreamVertexName).getConfiguration());
                int inputNumber = downStreamVertexConfig.getNumberOfInputs();
                downStreamVertexConfig.setInputType(inputNumber++, outEdgeTypeList.get(i));
                downStreamVertexConfig.setNumberOfInputs(inputNumber);
                this.connect(upStreamVertexName, downStreamVertexName, this.connectionTypes.get(upStreamVertexName).get(i));
                ++i;
            }
        }
        this.setSlotSharing();
        this.setNumberOfJobInputs();
        this.setNumberOfJobOutputs();
    }
}

