/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.postpass;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.compiler.postpass.AbstractSchema;
import org.apache.flink.compiler.postpass.ConflictingFieldTypeInfoException;
import org.apache.flink.types.Key;

public class SparseKeySchema
extends AbstractSchema<Class<? extends Key<?>>> {
    private final Map<Integer, Class<? extends Key<?>>> schema = new HashMap();

    @Override
    public void addType(int key, Class<? extends Key<?>> type) throws ConflictingFieldTypeInfoException {
        Class<? extends Key<?>> previous = this.schema.put(key, type);
        if (previous != null && previous != type) {
            throw new ConflictingFieldTypeInfoException(key, previous, type);
        }
    }

    @Override
    public Class<? extends Key<?>> getType(int field) {
        return this.schema.get(field);
    }

    @Override
    public Iterator<Map.Entry<Integer, Class<? extends Key<?>>>> iterator() {
        return this.schema.entrySet().iterator();
    }

    public int getNumTypes() {
        return this.schema.size();
    }

    public int hashCode() {
        return this.schema.hashCode() ^ this.getNumConnectionsThatContributed();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SparseKeySchema) {
            SparseKeySchema other = (SparseKeySchema)obj;
            return this.schema.equals(other.schema) && this.getNumConnectionsThatContributed() == other.getNumConnectionsThatContributed();
        }
        return false;
    }

    public String toString() {
        return "<" + this.getNumConnectionsThatContributed() + "> : " + this.schema.toString();
    }
}

