/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dag.SingleInputNode;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.NamedChannel;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class SingleInputPlanNode
extends PlanNode {
    protected final Channel input;
    protected final FieldList[] driverKeys;
    protected final boolean[][] driverSortOrders;
    private TypeComparatorFactory<?>[] comparators;
    public Object postPassHelper;

    public SingleInputPlanNode(OptimizerNode template, String nodeName, Channel input, DriverStrategy driverStrategy) {
        this(template, nodeName, input, driverStrategy, null, null);
    }

    public SingleInputPlanNode(OptimizerNode template, String nodeName, Channel input, DriverStrategy driverStrategy, FieldList driverKeyFields) {
        this(template, nodeName, input, driverStrategy, driverKeyFields, SingleInputPlanNode.getTrueArray(driverKeyFields.size()));
    }

    public SingleInputPlanNode(OptimizerNode template, String nodeName, Channel input, DriverStrategy driverStrategy, FieldList driverKeyFields, boolean[] driverSortOrders) {
        super(template, nodeName, driverStrategy);
        this.input = input;
        this.comparators = new TypeComparatorFactory[driverStrategy.getNumRequiredComparators()];
        this.driverKeys = new FieldList[driverStrategy.getNumRequiredComparators()];
        this.driverSortOrders = new boolean[driverStrategy.getNumRequiredComparators()][];
        if (driverStrategy.getNumRequiredComparators() > 0) {
            this.driverKeys[0] = driverKeyFields;
            this.driverSortOrders[0] = driverSortOrders;
        }
        if (this.input.getShipStrategy() == ShipStrategyType.BROADCAST) {
            this.input.setReplicationFactor(this.getDegreeOfParallelism());
        }
        PlanNode predNode = input.getSource();
        if (predNode.branchPlan != null && !predNode.branchPlan.isEmpty()) {
            if (this.branchPlan == null) {
                this.branchPlan = new HashMap();
            }
            this.branchPlan.putAll(predNode.branchPlan);
        }
    }

    public SingleInputNode getSingleInputNode() {
        if (this.template instanceof SingleInputNode) {
            return (SingleInputNode)this.template;
        }
        throw new RuntimeException();
    }

    public Channel getInput() {
        return this.input;
    }

    public PlanNode getPredecessor() {
        return this.input.getSource();
    }

    public void setDriverKeyInfo(FieldList keys, int id) {
        this.setDriverKeyInfo(keys, SingleInputPlanNode.getTrueArray(keys.size()), id);
    }

    public void setDriverKeyInfo(FieldList keys, boolean[] sortOrder, int id) {
        if (id < 0 || id >= this.driverKeys.length) {
            throw new CompilerException("Invalid id for driver key information. DriverStrategy requires only " + super.getDriverStrategy().getNumRequiredComparators() + " comparators.");
        }
        this.driverKeys[id] = keys;
        this.driverSortOrders[id] = sortOrder;
    }

    public FieldList getKeys(int id) {
        return this.driverKeys[id];
    }

    public boolean[] getSortOrders(int id) {
        return this.driverSortOrders[id];
    }

    public TypeComparatorFactory<?> getComparator(int id) {
        return this.comparators[id];
    }

    public void setComparator(TypeComparatorFactory<?> comparator, int id) {
        this.comparators[id] = comparator;
    }

    public void accept(Visitor<PlanNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            this.input.getSource().accept(visitor);
            for (Channel channel : this.getBroadcastInputs()) {
                channel.getSource().accept(visitor);
            }
            visitor.postVisit((Visitable)this);
        }
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        if (this.getBroadcastInputs() == null || this.getBroadcastInputs().isEmpty()) {
            return Collections.singleton(this.input.getSource());
        }
        ArrayList<PlanNode> preds = new ArrayList<PlanNode>();
        preds.add(this.input.getSource());
        for (Channel channel : this.getBroadcastInputs()) {
            preds.add(channel.getSource());
        }
        return preds;
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Collections.singleton(this.input);
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport res = this.input.getSource().hasDamOnPathDownTo(source);
        if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            return this.input.getLocalStrategy().dams() || this.input.getTempMode().breaksPipeline() || this.getDriverStrategy().firstDam() == DamBehavior.FULL_DAM ? PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM : PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        for (NamedChannel nc : this.getBroadcastInputs()) {
            PlanNode.SourceAndDamReport bcRes = nc.getSource().hasDamOnPathDownTo(source);
            if (bcRes == PlanNode.SourceAndDamReport.NOT_FOUND) continue;
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        return PlanNode.SourceAndDamReport.NOT_FOUND;
    }

    protected static boolean[] getTrueArray(int length) {
        boolean[] a = new boolean[length];
        for (int i = 0; i < length; ++i) {
            a[i] = true;
        }
        return a;
    }
}

