/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.plan;

import java.util.Collection;
import org.apache.flink.api.common.Plan;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.compiler.plan.SinkPlanNode;
import org.apache.flink.compiler.plan.SourcePlanNode;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class OptimizedPlan
implements Visitable<PlanNode> {
    private final Collection<SourcePlanNode> dataSources;
    private final Collection<SinkPlanNode> dataSinks;
    private final Collection<PlanNode> allNodes;
    private final Plan pactPlan;
    private final String jobName;
    private String instanceTypeName;

    public OptimizedPlan(Collection<SourcePlanNode> sources, Collection<SinkPlanNode> sinks, Collection<PlanNode> allNodes, String jobName, Plan pactPlan) {
        this.dataSources = sources;
        this.dataSinks = sinks;
        this.allNodes = allNodes;
        this.jobName = jobName;
        this.pactPlan = pactPlan;
    }

    public Collection<SourcePlanNode> getDataSources() {
        return this.dataSources;
    }

    public Collection<SinkPlanNode> getDataSinks() {
        return this.dataSinks;
    }

    public Collection<PlanNode> getAllNodes() {
        return this.allNodes;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Plan getOriginalPactPlan() {
        return this.pactPlan;
    }

    public String getInstanceTypeName() {
        return this.instanceTypeName;
    }

    public void setInstanceTypeName(String instanceTypeName) {
        this.instanceTypeName = instanceTypeName;
    }

    public void accept(Visitor<PlanNode> visitor) {
        for (SinkPlanNode node : this.dataSinks) {
            node.accept(visitor);
        }
    }
}

