/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.operators;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.dag.TwoInputNode;
import org.apache.flink.compiler.dataproperties.LocalProperties;
import org.apache.flink.compiler.dataproperties.RequestedLocalProperties;
import org.apache.flink.compiler.operators.AbstractJoinDescriptor;
import org.apache.flink.compiler.operators.OperatorDescriptorDual;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.DualInputPlanNode;
import org.apache.flink.compiler.util.Utils;
import org.apache.flink.runtime.operators.DriverStrategy;

public class SortMergeJoinDescriptor
extends AbstractJoinDescriptor {
    public SortMergeJoinDescriptor(FieldList keys1, FieldList keys2) {
        super(keys1, keys2);
    }

    public SortMergeJoinDescriptor(FieldList keys1, FieldList keys2, boolean broadcastFirstAllowed, boolean broadcastSecondAllowed, boolean repartitionAllowed) {
        super(keys1, keys2, broadcastFirstAllowed, broadcastSecondAllowed, repartitionAllowed);
    }

    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.MERGE;
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        RequestedLocalProperties sort1 = new RequestedLocalProperties(Utils.createOrdering(this.keys1));
        RequestedLocalProperties sort2 = new RequestedLocalProperties(Utils.createOrdering(this.keys2));
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(sort1, sort2));
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        int numRelevantFields = this.keys1.size();
        Ordering prod1 = produced1.getOrdering();
        Ordering prod2 = produced2.getOrdering();
        if (prod1 == null || prod2 == null || prod1.getNumberOfFields() < numRelevantFields || prod2.getNumberOfFields() < prod2.getNumberOfFields()) {
            throw new CompilerException("The given properties do not meet this operators requirements.");
        }
        for (int i = 0; i < numRelevantFields; ++i) {
            if (prod1.getOrder(i) == prod2.getOrder(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        boolean[] inputOrders = in1.getLocalProperties().getOrdering().getFieldSortDirections();
        if (inputOrders == null || inputOrders.length < this.keys1.size()) {
            throw new CompilerException("BUG: The input strategy does not sufficiently describe the sort orders for a merge operator.");
        }
        if (inputOrders.length > this.keys1.size()) {
            boolean[] tmp = new boolean[this.keys1.size()];
            System.arraycopy(inputOrders, 0, tmp, 0, tmp.length);
            inputOrders = tmp;
        }
        return new DualInputPlanNode(node, "Join(" + node.getPactContract().getName() + ")", in1, in2, DriverStrategy.MERGE, this.keys1, this.keys2, inputOrders);
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
        LocalProperties comb = LocalProperties.combine(in1, in2);
        return comb.clearUniqueFieldSets();
    }
}

