/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.deadlockdetect;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.compiler.deadlockdetect.DeadlockGraph;
import org.apache.flink.compiler.deadlockdetect.DeadlockVertex;
import org.apache.flink.compiler.plan.BulkIterationPlanNode;
import org.apache.flink.compiler.plan.DualInputPlanNode;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.compiler.plan.WorksetIterationPlanNode;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitor;

public class DeadlockPreventer
implements Visitor<PlanNode> {
    private DeadlockGraph g = new DeadlockGraph();

    public void resolveDeadlocks(List<? extends PlanNode> sinks) {
        for (PlanNode planNode : sinks) {
            planNode.accept(this);
        }
        if (this.g.hasCycle()) {
            for (DeadlockVertex deadlockVertex : this.g.vertices) {
                if (deadlockVertex.getOriginal().getDriverStrategy().equals((Object)DriverStrategy.HYBRIDHASH_BUILD_FIRST)) {
                    deadlockVertex.getOriginal().setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
                    if (!this.hasDeadlock(sinks)) break;
                    deadlockVertex.getOriginal().setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_FIRST);
                }
                if (!deadlockVertex.getOriginal().getDriverStrategy().equals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND)) continue;
                deadlockVertex.getOriginal().setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_FIRST);
                if (!this.hasDeadlock(sinks)) break;
                deadlockVertex.getOriginal().setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
            }
            for (DeadlockVertex deadlockVertex : this.g.vertices) {
                if (!(deadlockVertex.getOriginal() instanceof DualInputPlanNode)) continue;
                DualInputPlanNode n = (DualInputPlanNode)deadlockVertex.getOriginal();
                if (!n.getDriverStrategy().firstDam().equals((Object)DamBehavior.FULL_DAM) && !n.getInput1().getLocalStrategy().dams() && !n.getInput1().getTempMode().breaksPipeline() && (n.getDriverStrategy().secondDam().equals((Object)DamBehavior.FULL_DAM) || n.getInput2().getLocalStrategy().dams() || n.getInput2().getTempMode().breaksPipeline())) {
                    n.getInput1().setTempMode(n.getInput1().getTempMode().makePipelineBreaker());
                } else if (!n.getDriverStrategy().secondDam().equals((Object)DamBehavior.FULL_DAM) && !n.getInput2().getLocalStrategy().dams() && !n.getInput2().getTempMode().breaksPipeline() && (n.getDriverStrategy().firstDam().equals((Object)DamBehavior.FULL_DAM) || n.getInput1().getLocalStrategy().dams() || n.getInput1().getTempMode().breaksPipeline())) {
                    n.getInput2().setTempMode(n.getInput2().getTempMode().makePipelineBreaker());
                }
                if (this.hasDeadlock(sinks)) continue;
                break;
            }
        }
    }

    public boolean hasDeadlock(List<? extends PlanNode> sinks) {
        this.g = new DeadlockGraph();
        for (PlanNode planNode : sinks) {
            planNode.accept(this);
        }
        return this.g.hasCycle();
    }

    public boolean preVisit(PlanNode visitable) {
        this.g.addVertex(visitable);
        return true;
    }

    public void postVisit(PlanNode visitable) {
        DeadlockPreventer dp;
        PlanNode n;
        if (visitable instanceof SingleInputPlanNode) {
            n = (SingleInputPlanNode)visitable;
            if (n.getDriverStrategy().firstDam().equals((Object)DamBehavior.FULL_DAM) || ((SingleInputPlanNode)n).getInput().getLocalStrategy().dams() || ((SingleInputPlanNode)n).getInput().getTempMode().breaksPipeline()) {
                this.g.addEdge(n, ((SingleInputPlanNode)n).getPredecessor());
            } else {
                this.g.addEdge(((SingleInputPlanNode)n).getPredecessor(), n);
            }
        } else if (visitable instanceof DualInputPlanNode) {
            n = (DualInputPlanNode)visitable;
            if (n.getDriverStrategy().firstDam().equals((Object)DamBehavior.FULL_DAM) || ((DualInputPlanNode)n).getInput1().getLocalStrategy().dams() || ((DualInputPlanNode)n).getInput1().getTempMode().breaksPipeline()) {
                this.g.addEdge(n, ((DualInputPlanNode)n).getInput1().getSource());
            } else {
                this.g.addEdge(((DualInputPlanNode)n).getInput1().getSource(), n);
            }
            if (!n.getDriverStrategy().equals((Object)DriverStrategy.NONE) && (n.getDriverStrategy().secondDam().equals((Object)DamBehavior.FULL_DAM) || ((DualInputPlanNode)n).getInput2().getLocalStrategy().dams() || ((DualInputPlanNode)n).getInput2().getTempMode().breaksPipeline())) {
                this.g.addEdge(n, ((DualInputPlanNode)n).getInput2().getSource());
            } else {
                this.g.addEdge(((DualInputPlanNode)n).getInput2().getSource(), n);
            }
        }
        if (visitable instanceof BulkIterationPlanNode) {
            dp = new DeadlockPreventer();
            ArrayList<PlanNode> planSinks = new ArrayList<PlanNode>(1);
            BulkIterationPlanNode pspn = (BulkIterationPlanNode)visitable;
            planSinks.add(pspn.getRootOfStepFunction());
            dp.resolveDeadlocks(planSinks);
        } else if (visitable instanceof WorksetIterationPlanNode) {
            dp = new DeadlockPreventer();
            ArrayList<PlanNode> planSinks = new ArrayList<PlanNode>(2);
            WorksetIterationPlanNode pspn = (WorksetIterationPlanNode)visitable;
            planSinks.add(pspn.getSolutionSetDeltaPlanNode());
            planSinks.add(pspn.getNextWorkSetPlanNode());
            dp.resolveDeadlocks(planSinks);
        }
    }
}

