/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.dag.SingleInputNode;
import org.apache.flink.compiler.operators.AllReduceProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorSingle;
import org.apache.flink.compiler.operators.ReduceProperties;

public class ReduceNode
extends SingleInputNode {
    private final List<OperatorDescriptorSingle> possibleProperties;
    private ReduceNode preReduceUtilityNode;

    public ReduceNode(ReduceOperatorBase<?, ?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
        if (this.keys == null) {
            this.setDegreeOfParallelism(1);
        }
        OperatorDescriptorSingle props = this.keys == null ? new AllReduceProperties() : new ReduceProperties(this.keys, operator.getCustomPartitioner());
        this.possibleProperties = Collections.singletonList(props);
    }

    public ReduceNode(ReduceNode reducerToCopyForCombiner) {
        super(reducerToCopyForCombiner);
        this.possibleProperties = Collections.emptyList();
    }

    public ReduceOperatorBase<?, ?> getPactContract() {
        return (ReduceOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Reduce";
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return this.possibleProperties;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    public ReduceNode getCombinerUtilityNode() {
        if (this.preReduceUtilityNode == null) {
            this.preReduceUtilityNode = new ReduceNode(this);
            this.preReduceUtilityNode.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
            this.preReduceUtilityNode.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        }
        return this.preReduceUtilityNode;
    }
}

