/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import org.apache.flink.compiler.dag.EstimateProvider;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dag.TempMode;
import org.apache.flink.compiler.dataproperties.InterestingProperties;
import org.apache.flink.compiler.plandump.DumpableConnection;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public class PactConnection
implements EstimateProvider,
DumpableConnection<OptimizerNode> {
    private final OptimizerNode source;
    private final OptimizerNode target;
    private InterestingProperties interestingProps;
    private ShipStrategyType shipStrategy;
    private TempMode materializationMode = TempMode.NONE;
    private int maxDepth = -1;

    public PactConnection(OptimizerNode source, OptimizerNode target) {
        this(source, target, null);
    }

    public PactConnection(OptimizerNode source, OptimizerNode target, ShipStrategyType shipStrategy) {
        if (source == null || target == null) {
            throw new NullPointerException("Source and target must not be null.");
        }
        this.source = source;
        this.target = target;
        this.shipStrategy = shipStrategy;
    }

    public PactConnection(OptimizerNode source) {
        if (source == null) {
            throw new NullPointerException("Source and target must not be null.");
        }
        this.source = source;
        this.target = null;
        this.shipStrategy = ShipStrategyType.NONE;
    }

    public OptimizerNode getSource() {
        return this.source;
    }

    public OptimizerNode getTarget() {
        return this.target;
    }

    @Override
    public ShipStrategyType getShipStrategy() {
        return this.shipStrategy;
    }

    public void setShipStrategy(ShipStrategyType strategy) {
        this.shipStrategy = strategy;
    }

    public InterestingProperties getInterestingProperties() {
        return this.interestingProps;
    }

    public void setInterestingProperties(InterestingProperties props) {
        if (this.interestingProps != null) {
            throw new IllegalStateException("Interesting Properties have already been set.");
        }
        this.interestingProps = props;
    }

    public void clearInterestingProperties() {
        this.interestingProps = null;
    }

    public void initMaxDepth() {
        if (this.maxDepth != -1) {
            throw new IllegalStateException("Maximum path depth has already been initialized.");
        }
        this.maxDepth = this.source.getMaxDepth() + 1;
    }

    public int getMaxDepth() {
        if (this.maxDepth != -1) {
            return this.maxDepth;
        }
        throw new IllegalStateException("Maximum path depth has not been initialized.");
    }

    @Override
    public long getEstimatedOutputSize() {
        return this.source.getEstimatedOutputSize();
    }

    @Override
    public long getEstimatedNumRecords() {
        return this.source.getEstimatedNumRecords();
    }

    @Override
    public float getEstimatedAvgWidthPerOutputRecord() {
        return this.source.getEstimatedAvgWidthPerOutputRecord();
    }

    public TempMode getMaterializationMode() {
        return this.materializationMode;
    }

    public void setMaterializationMode(TempMode materializationMode) {
        this.materializationMode = materializationMode;
    }

    public boolean isOnDynamicPath() {
        return this.source.isOnDynamicPath();
    }

    public int getCostWeight() {
        return this.source.getCostWeight();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        buf.append("Connection: ");
        if (this.source == null) {
            buf.append("null");
        } else {
            buf.append(this.source.getPactContract().getName());
            buf.append('(').append(this.source.getName()).append(')');
        }
        buf.append(" -> ");
        if (this.shipStrategy != null) {
            buf.append('[');
            buf.append(this.shipStrategy.name());
            buf.append(']').append(' ');
        }
        if (this.target == null) {
            buf.append("null");
        } else {
            buf.append(this.target.getPactContract().getName());
            buf.append('(').append(this.target.getName()).append(')');
        }
        return buf.toString();
    }
}

