/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.dag.TwoInputNode;
import org.apache.flink.compiler.operators.CartesianProductDescriptor;
import org.apache.flink.compiler.operators.CrossBlockOuterFirstDescriptor;
import org.apache.flink.compiler.operators.CrossBlockOuterSecondDescriptor;
import org.apache.flink.compiler.operators.CrossStreamOuterFirstDescriptor;
import org.apache.flink.compiler.operators.CrossStreamOuterSecondDescriptor;
import org.apache.flink.compiler.operators.OperatorDescriptorDual;
import org.apache.flink.configuration.Configuration;

public class CrossNode
extends TwoInputNode {
    private final List<OperatorDescriptorDual> dataProperties;

    public CrossNode(CrossOperatorBase<?, ?, ?, ?> operation) {
        super((DualInputOperator<?, ?, ?, ?>)operation);
        boolean allowBCfirst = true;
        boolean allowBCsecond = true;
        if (operation instanceof CrossOperatorBase.CrossWithSmall) {
            allowBCfirst = false;
        } else if (operation instanceof CrossOperatorBase.CrossWithLarge) {
            allowBCsecond = false;
        }
        Configuration conf = operation.getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            CartesianProductDescriptor fixedDriverStrat;
            if ("LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_FIRST".equals(localStrategy)) {
                fixedDriverStrat = new CrossBlockOuterFirstDescriptor(allowBCfirst, allowBCsecond);
            } else if ("LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_SECOND".equals(localStrategy)) {
                fixedDriverStrat = new CrossBlockOuterSecondDescriptor(allowBCfirst, allowBCsecond);
            } else if ("LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_FIRST".equals(localStrategy)) {
                fixedDriverStrat = new CrossStreamOuterFirstDescriptor(allowBCfirst, allowBCsecond);
            } else if ("LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_SECOND".equals(localStrategy)) {
                fixedDriverStrat = new CrossStreamOuterSecondDescriptor(allowBCfirst, allowBCsecond);
            } else {
                throw new CompilerException("Invalid local strategy hint for cross contract: " + localStrategy);
            }
            this.dataProperties = Collections.singletonList(fixedDriverStrat);
        } else if (operation instanceof CrossOperatorBase.CrossWithSmall) {
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(new CrossBlockOuterSecondDescriptor(false, true));
            list.add(new CrossStreamOuterFirstDescriptor(false, true));
            this.dataProperties = list;
        } else if (operation instanceof CrossOperatorBase.CrossWithLarge) {
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(new CrossBlockOuterFirstDescriptor(true, false));
            list.add(new CrossStreamOuterSecondDescriptor(true, false));
            this.dataProperties = list;
        } else {
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(new CrossBlockOuterFirstDescriptor());
            list.add(new CrossBlockOuterSecondDescriptor());
            list.add(new CrossStreamOuterFirstDescriptor());
            list.add(new CrossStreamOuterSecondDescriptor());
            this.dataProperties = list;
        }
    }

    public CrossOperatorBase<?, ?, ?, ?> getPactContract() {
        return (CrossOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Cross";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return this.dataProperties;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        long l = this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : card1 * card2;
        if (this.estimatedNumRecords >= 0L) {
            float width;
            float width1 = this.getFirstPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float width2 = this.getSecondPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float f = width = width1 <= 0.0f || width2 <= 0.0f ? -1.0f : width1 + width2;
            if (width > 0.0f) {
                this.estimatedOutputSize = (long)(width * (float)this.estimatedNumRecords);
            }
        }
    }
}

