/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.PactCompiler;
import org.apache.flink.compiler.costs.CostEstimator;
import org.apache.flink.compiler.dag.BinaryUnionNode;
import org.apache.flink.compiler.dag.BulkPartialSolutionNode;
import org.apache.flink.compiler.dag.InterestingPropertiesClearer;
import org.apache.flink.compiler.dag.IterationNode;
import org.apache.flink.compiler.dag.NoOpNode;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dag.PactConnection;
import org.apache.flink.compiler.dag.PlanCacheCleaner;
import org.apache.flink.compiler.dag.SingleInputNode;
import org.apache.flink.compiler.dag.UnaryOperatorNode;
import org.apache.flink.compiler.dag.WorksetIterationNode;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.InterestingProperties;
import org.apache.flink.compiler.dataproperties.LocalProperties;
import org.apache.flink.compiler.dataproperties.RequestedGlobalProperties;
import org.apache.flink.compiler.dataproperties.RequestedLocalProperties;
import org.apache.flink.compiler.operators.NoOpDescriptor;
import org.apache.flink.compiler.operators.OperatorDescriptorSingle;
import org.apache.flink.compiler.plan.BulkIterationPlanNode;
import org.apache.flink.compiler.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.NamedChannel;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitor;

public class BulkIterationNode
extends SingleInputNode
implements IterationNode {
    private BulkPartialSolutionNode partialSolution;
    private OptimizerNode terminationCriterion;
    private OptimizerNode nextPartialSolution;
    private PactConnection rootConnection;
    private PactConnection terminationCriterionRootConnection;
    private OptimizerNode singleRoot;
    private final int costWeight;

    public BulkIterationNode(BulkIterationBase<?> iteration) {
        super((SingleInputOperator<?, ?, ?>)iteration);
        if (iteration.getMaximumNumberOfIterations() <= 0) {
            throw new CompilerException("BulkIteration must have a maximum number of iterations specified.");
        }
        int numIters = iteration.getMaximumNumberOfIterations();
        this.costWeight = numIters > 0 && numIters < 100 ? numIters : 100;
    }

    public BulkIterationBase<?> getIterationContract() {
        return (BulkIterationBase)this.getPactContract();
    }

    public BulkPartialSolutionNode getPartialSolution() {
        return this.partialSolution;
    }

    public void setPartialSolution(BulkPartialSolutionNode partialSolution) {
        this.partialSolution = partialSolution;
    }

    public OptimizerNode getNextPartialSolution() {
        return this.nextPartialSolution;
    }

    public void setNextPartialSolution(OptimizerNode nextPartialSolution, OptimizerNode terminationCriterion) {
        if (nextPartialSolution.getDegreeOfParallelism() != this.getDegreeOfParallelism() || nextPartialSolution == this.partialSolution || nextPartialSolution instanceof BinaryUnionNode) {
            NoOpNode noop = new NoOpNode();
            noop.setDegreeOfParallelism(this.getDegreeOfParallelism());
            PactConnection noOpConn = new PactConnection(nextPartialSolution, noop);
            noop.setIncomingConnection(noOpConn);
            nextPartialSolution.addOutgoingConnection(noOpConn);
            nextPartialSolution = noop;
        }
        this.nextPartialSolution = nextPartialSolution;
        this.terminationCriterion = terminationCriterion;
        if (terminationCriterion == null) {
            this.singleRoot = nextPartialSolution;
            this.rootConnection = new PactConnection(nextPartialSolution);
        } else {
            WorksetIterationNode.SingleRootJoiner singleRootJoiner = new WorksetIterationNode.SingleRootJoiner();
            this.rootConnection = new PactConnection(nextPartialSolution, singleRootJoiner);
            this.terminationCriterionRootConnection = new PactConnection(terminationCriterion, singleRootJoiner);
            singleRootJoiner.setInputs(this.rootConnection, this.terminationCriterionRootConnection);
            this.singleRoot = singleRootJoiner;
            terminationCriterion.addOutgoingConnection(this.terminationCriterionRootConnection);
        }
        nextPartialSolution.addOutgoingConnection(this.rootConnection);
    }

    @Override
    public int getCostWeight() {
        return this.costWeight;
    }

    public OptimizerNode getSingleRootOfStepFunction() {
        return this.singleRoot;
    }

    @Override
    public String getName() {
        return "Bulk Iteration";
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        return false;
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
        this.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return Collections.singletonList(new NoOpDescriptor());
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties intProps = this.getInterestingProperties().clone();
        if (this.terminationCriterion != null) {
            this.terminationCriterionRootConnection.setInterestingProperties(new InterestingProperties());
            this.terminationCriterion.accept(new PactCompiler.InterestingPropertyVisitor(estimator));
        }
        this.rootConnection.setInterestingProperties(intProps);
        this.nextPartialSolution.accept(new PactCompiler.InterestingPropertyVisitor(estimator));
        InterestingProperties partialSolutionIntProps = this.partialSolution.getInterestingProperties();
        intProps.getGlobalProperties().addAll(partialSolutionIntProps.getGlobalProperties());
        intProps.getLocalProperties().addAll(partialSolutionIntProps.getLocalProperties());
        this.rootConnection.clearInterestingProperties();
        this.nextPartialSolution.accept(InterestingPropertiesClearer.INSTANCE);
        this.rootConnection.setInterestingProperties(intProps);
        this.nextPartialSolution.accept(new PactCompiler.InterestingPropertyVisitor(estimator));
        InterestingProperties inProps = this.partialSolution.getInterestingProperties().clone();
        inProps.addGlobalProperties(new RequestedGlobalProperties());
        inProps.addLocalProperties(new RequestedLocalProperties());
        this.inConn.setInterestingProperties(inProps);
    }

    @Override
    public void clearInterestingProperties() {
        super.clearInterestingProperties();
        this.singleRoot.accept(InterestingPropertiesClearer.INSTANCE);
        this.rootConnection.clearInterestingProperties();
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getSingleRootOfStepFunction().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.getSingleRootOfStepFunction().openBranches;
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    protected void instantiateCandidate(OperatorDescriptorSingle dps, Channel in, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReq, RequestedLocalProperties locPropsReq) {
        block8: {
            List<PlanNode> candidates;
            BulkPartialSolutionPlanNode pspn;
            block7: {
                this.nextPartialSolution.accept(PlanCacheCleaner.INSTANCE);
                if (this.terminationCriterion != null) {
                    this.terminationCriterion.accept(PlanCacheCleaner.INSTANCE);
                }
                this.partialSolution.setCandidateProperties(in.getGlobalProperties(), in.getLocalProperties(), in);
                pspn = this.partialSolution.getCurrentPartialSolutionPlanNode();
                candidates = this.nextPartialSolution.getAlternativePlans(estimator);
                ArrayList<SingleInputPlanNode> newCandidates = new ArrayList<SingleInputPlanNode>();
                Iterator<PlanNode> planDeleter = candidates.iterator();
                while (planDeleter.hasNext()) {
                    PlanNode.FeedbackPropertiesMeetRequirementsReport report2;
                    LocalProperties atEndLocal;
                    GlobalProperties atEndGlobal;
                    PlanNode candidate = planDeleter.next();
                    PlanNode.FeedbackPropertiesMeetRequirementsReport report = candidate.checkPartialSolutionPropertiesMet(pspn, atEndGlobal = candidate.getGlobalProperties(), atEndLocal = candidate.getLocalProperties());
                    if (report == PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION || report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET) continue;
                    Channel toNoOp = new Channel(candidate);
                    globPropsReq.parameterizeChannel(toNoOp, false);
                    locPropsReq.parameterizeChannel(toNoOp);
                    UnaryOperatorNode rebuildPropertiesNode = new UnaryOperatorNode("Rebuild Partial Solution Properties", (FieldSet)FieldList.EMPTY_LIST, new OperatorDescriptorSingle[0]);
                    rebuildPropertiesNode.setDegreeOfParallelism(candidate.getDegreeOfParallelism());
                    SingleInputPlanNode rebuildPropertiesPlanNode = new SingleInputPlanNode(rebuildPropertiesNode, "Rebuild Partial Solution Properties", toNoOp, DriverStrategy.UNARY_NO_OP);
                    rebuildPropertiesPlanNode.initProperties(toNoOp.getGlobalProperties(), toNoOp.getLocalProperties());
                    estimator.costOperator(rebuildPropertiesPlanNode);
                    GlobalProperties atEndGlobalModified = rebuildPropertiesPlanNode.getGlobalProperties();
                    LocalProperties atEndLocalModified = rebuildPropertiesPlanNode.getLocalProperties();
                    if (!(atEndGlobalModified.equals(atEndGlobal) && atEndLocalModified.equals(atEndLocal) || (report2 = candidate.checkPartialSolutionPropertiesMet(pspn, atEndGlobalModified, atEndLocalModified)) == PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET)) {
                        newCandidates.add(rebuildPropertiesPlanNode);
                    }
                    planDeleter.remove();
                }
                if (candidates.isEmpty()) {
                    return;
                }
                if (this.terminationCriterion != null) break block7;
                for (PlanNode candidate : candidates) {
                    BulkIterationPlanNode node = new BulkIterationPlanNode(this, "BulkIteration (" + this.getPactContract().getName() + ")", in, pspn, candidate);
                    GlobalProperties gProps = candidate.getGlobalProperties().clone();
                    LocalProperties lProps = candidate.getLocalProperties().clone();
                    node.initProperties(gProps, lProps);
                    target.add(node);
                }
                break block8;
            }
            if (candidates.size() <= 0) break block8;
            List<PlanNode> terminationCriterionCandidates = this.terminationCriterion.getAlternativePlans(estimator);
            WorksetIterationNode.SingleRootJoiner singleRoot = (WorksetIterationNode.SingleRootJoiner)this.singleRoot;
            for (PlanNode candidate : candidates) {
                for (PlanNode terminationCandidate : terminationCriterionCandidates) {
                    if (!singleRoot.areBranchCompatible(candidate, terminationCandidate)) continue;
                    BulkIterationPlanNode node = new BulkIterationPlanNode(this, "BulkIteration (" + this.getPactContract().getName() + ")", in, pspn, candidate, terminationCandidate);
                    GlobalProperties gProps = candidate.getGlobalProperties().clone();
                    LocalProperties lProps = candidate.getLocalProperties().clone();
                    node.initProperties(gProps, lProps);
                    target.add(node);
                }
            }
        }
    }

    @Override
    public void acceptForStepFunction(Visitor<OptimizerNode> visitor) {
        this.singleRoot.accept(visitor);
    }
}

