/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.costs;

import java.util.Iterator;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.costs.Costs;
import org.apache.flink.compiler.dag.EstimateProvider;
import org.apache.flink.compiler.dag.TempMode;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.PlanNode;

public abstract class CostEstimator {
    public abstract void addRandomPartitioningCost(EstimateProvider var1, Costs var2);

    public abstract void addHashPartitioningCost(EstimateProvider var1, Costs var2);

    public abstract void addRangePartitionCost(EstimateProvider var1, Costs var2);

    public abstract void addBroadcastCost(EstimateProvider var1, int var2, Costs var3);

    public abstract void addFileInputCost(long var1, Costs var3);

    public abstract void addLocalSortCost(EstimateProvider var1, Costs var2);

    public abstract void addLocalMergeCost(EstimateProvider var1, EstimateProvider var2, Costs var3, int var4);

    public abstract void addHybridHashCosts(EstimateProvider var1, EstimateProvider var2, Costs var3, int var4);

    public abstract void addCachedHybridHashCosts(EstimateProvider var1, EstimateProvider var2, Costs var3, int var4);

    public abstract void addStreamedNestedLoopsCosts(EstimateProvider var1, EstimateProvider var2, long var3, Costs var5, int var6);

    public abstract void addBlockNestedLoopsCosts(EstimateProvider var1, EstimateProvider var2, long var3, Costs var5, int var6);

    public abstract void addArtificialDamCost(EstimateProvider var1, long var2, Costs var4);

    public void costOperator(PlanNode n) {
        Iterator<Channel> channels;
        Costs totalCosts = new Costs();
        long availableMemory = n.getGuaranteedAvailableMemory();
        for (Channel channel : n.getInputs()) {
            Costs costs = new Costs();
            switch (channel.getShipStrategy()) {
                case NONE: {
                    throw new CompilerException("Cannot determine costs: Shipping strategy has not been set for an input.");
                }
                case FORWARD: {
                    break;
                }
                case PARTITION_RANDOM: {
                    this.addRandomPartitioningCost(channel, costs);
                    break;
                }
                case PARTITION_HASH: 
                case PARTITION_CUSTOM: {
                    this.addHashPartitioningCost(channel, costs);
                    break;
                }
                case PARTITION_RANGE: {
                    this.addRangePartitionCost(channel, costs);
                    break;
                }
                case BROADCAST: {
                    this.addBroadcastCost(channel, channel.getReplicationFactor(), costs);
                    break;
                }
                case PARTITION_FORCED_REBALANCE: {
                    this.addRandomPartitioningCost(channel, costs);
                    break;
                }
                default: {
                    throw new CompilerException("Unknown shipping strategy for input: " + channel.getShipStrategy());
                }
            }
            switch (channel.getLocalStrategy()) {
                case NONE: {
                    break;
                }
                case SORT: 
                case COMBININGSORT: {
                    this.addLocalSortCost(channel, costs);
                    break;
                }
                default: {
                    throw new CompilerException("Unsupported local strategy for input: " + channel.getLocalStrategy());
                }
            }
            if (channel.getTempMode() != null && channel.getTempMode() != TempMode.NONE) {
                this.addArtificialDamCost(channel, 0L, costs);
            }
            if (channel.isOnDynamicPath()) {
                costs.multiplyWith(channel.getCostWeight());
            }
            totalCosts.addCosts(costs);
        }
        Channel firstInput = null;
        Channel secondInput = null;
        Costs driverCosts = new Costs();
        int costWeight = 1;
        if (n.isOnDynamicPath()) {
            costWeight = n.getCostWeight();
        }
        if ((channels = n.getInputs().iterator()).hasNext()) {
            firstInput = channels.next();
        }
        if (channels.hasNext()) {
            secondInput = channels.next();
        }
        switch (n.getDriverStrategy()) {
            case NONE: 
            case UNARY_NO_OP: 
            case BINARY_NO_OP: 
            case COLLECTOR_MAP: 
            case MAP: 
            case MAP_PARTITION: 
            case FLAT_MAP: 
            case ALL_GROUP_REDUCE: 
            case ALL_REDUCE: 
            case CO_GROUP: 
            case SORTED_GROUP_REDUCE: 
            case SORTED_REDUCE: 
            case SORTED_GROUP_COMBINE: 
            case UNION: {
                break;
            }
            case MERGE: {
                this.addLocalMergeCost(firstInput, secondInput, driverCosts, costWeight);
                break;
            }
            case HYBRIDHASH_BUILD_FIRST: {
                this.addHybridHashCosts(firstInput, secondInput, driverCosts, costWeight);
                break;
            }
            case HYBRIDHASH_BUILD_SECOND: {
                this.addHybridHashCosts(secondInput, firstInput, driverCosts, costWeight);
                break;
            }
            case HYBRIDHASH_BUILD_FIRST_CACHED: {
                this.addCachedHybridHashCosts(firstInput, secondInput, driverCosts, costWeight);
                break;
            }
            case HYBRIDHASH_BUILD_SECOND_CACHED: {
                this.addCachedHybridHashCosts(secondInput, firstInput, driverCosts, costWeight);
                break;
            }
            case NESTEDLOOP_BLOCKED_OUTER_FIRST: {
                this.addBlockNestedLoopsCosts(firstInput, secondInput, availableMemory, driverCosts, costWeight);
                break;
            }
            case NESTEDLOOP_BLOCKED_OUTER_SECOND: {
                this.addBlockNestedLoopsCosts(secondInput, firstInput, availableMemory, driverCosts, costWeight);
                break;
            }
            case NESTEDLOOP_STREAMED_OUTER_FIRST: {
                this.addStreamedNestedLoopsCosts(firstInput, secondInput, availableMemory, driverCosts, costWeight);
                break;
            }
            case NESTEDLOOP_STREAMED_OUTER_SECOND: {
                this.addStreamedNestedLoopsCosts(secondInput, firstInput, availableMemory, driverCosts, costWeight);
                break;
            }
            default: {
                throw new CompilerException("Unknown local strategy: " + n.getDriverStrategy().name());
            }
        }
        totalCosts.addCosts(driverCosts);
        n.setCosts(totalCosts);
    }
}

