/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

public class SerializableArrayList<E extends IOReadableWritable>
extends ArrayList<E>
implements IOReadableWritable {
    private static final long serialVersionUID = 8196856588290198537L;

    public SerializableArrayList() {
    }

    public SerializableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (IOReadableWritable element : this) {
            StringRecord.writeString((DataOutput)out, (String)element.getClass().getName());
            element.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.clear();
        int numberOfElements = in.readInt();
        for (int i = 0; i < numberOfElements; ++i) {
            String elementType = StringRecord.readString((DataInput)in);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(elementType);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable element = null;
            try {
                element = (IOReadableWritable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            element.read(in);
            this.add(element);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SerializableArrayList)) {
            return false;
        }
        return obj instanceof SerializableArrayList && super.equals(obj);
    }
}

