/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.protocols.InputSplitProviderProtocol;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final InputSplitProviderProtocol protocol;
    private final JobID jobId;
    private final JobVertexID vertexId;
    private final ExecutionAttemptID executionAttempt;

    public TaskInputSplitProvider(InputSplitProviderProtocol protocol, JobID jobId, JobVertexID vertexId, ExecutionAttemptID executionAttempt) {
        this.protocol = protocol;
        this.jobId = jobId;
        this.vertexId = vertexId;
        this.executionAttempt = executionAttempt;
    }

    @Override
    public InputSplit getNextInputSplit() {
        try {
            return this.protocol.requestNextInputSplit(this.jobId, this.vertexId, this.executionAttempt);
        }
        catch (IOException e) {
            throw new RuntimeException("Requesting the next InputSplit failed.", e);
        }
    }
}

