/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.profiling.types.ProfilingEvent;

public abstract class InstanceProfilingEvent
extends ProfilingEvent {
    private static final long serialVersionUID = 5964092674722506040L;
    private int profilingInterval;
    private int ioWaitCPU;
    private int idleCPU;
    private int userCPU;
    private int systemCPU;
    private int hardIrqCPU;
    private int softIrqCPU;
    private long totalMemory;
    private long freeMemory;
    private long bufferedMemory;
    private long cachedMemory;
    private long cachedSwapMemory;
    private long receivedBytes;
    private long transmittedBytes;

    public InstanceProfilingEvent(int profilingInterval, int ioWaitCPU, int idleCPU, int userCPU, int systemCPU, int hardIrqCPU, int softIrqCPU, long totalMemory, long freeMemory, long bufferedMemory, long cachedMemory, long cachedSwapMemory, long receivedBytes, long transmittedBytes, JobID jobID, long timestamp, long profilingTimestamp) {
        super(jobID, timestamp, profilingTimestamp);
        this.profilingInterval = profilingInterval;
        this.ioWaitCPU = ioWaitCPU;
        this.idleCPU = idleCPU;
        this.userCPU = userCPU;
        this.systemCPU = systemCPU;
        this.hardIrqCPU = hardIrqCPU;
        this.softIrqCPU = softIrqCPU;
        this.totalMemory = totalMemory;
        this.freeMemory = freeMemory;
        this.bufferedMemory = bufferedMemory;
        this.cachedMemory = cachedMemory;
        this.cachedSwapMemory = cachedSwapMemory;
        this.receivedBytes = receivedBytes;
        this.transmittedBytes = transmittedBytes;
    }

    public InstanceProfilingEvent() {
    }

    public final int getProfilingInterval() {
        return this.profilingInterval;
    }

    public final long getTotalMemory() {
        return this.totalMemory;
    }

    public final long getFreeMemory() {
        return this.freeMemory;
    }

    public final long getBufferedMemory() {
        return this.bufferedMemory;
    }

    public final long getCachedMemory() {
        return this.cachedMemory;
    }

    public final long getCachedSwapMemory() {
        return this.cachedSwapMemory;
    }

    public final int getUserCPU() {
        return this.userCPU;
    }

    public final int getSystemCPU() {
        return this.systemCPU;
    }

    public final int getIdleCPU() {
        return this.idleCPU;
    }

    public final int getIOWaitCPU() {
        return this.ioWaitCPU;
    }

    public final int getHardIrqCPU() {
        return this.hardIrqCPU;
    }

    public final int getSoftIrqCPU() {
        return this.softIrqCPU;
    }

    public final long getReceivedBytes() {
        return this.receivedBytes;
    }

    public final long getTransmittedBytes() {
        return this.transmittedBytes;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.profilingInterval = in.readInt();
        this.ioWaitCPU = in.readInt();
        this.idleCPU = in.readInt();
        this.userCPU = in.readInt();
        this.systemCPU = in.readInt();
        this.hardIrqCPU = in.readInt();
        this.softIrqCPU = in.readInt();
        this.totalMemory = in.readLong();
        this.freeMemory = in.readLong();
        this.bufferedMemory = in.readLong();
        this.cachedMemory = in.readLong();
        this.cachedSwapMemory = in.readLong();
        this.receivedBytes = in.readLong();
        this.transmittedBytes = in.readLong();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.profilingInterval);
        out.writeInt(this.ioWaitCPU);
        out.writeInt(this.idleCPU);
        out.writeInt(this.userCPU);
        out.writeInt(this.systemCPU);
        out.writeInt(this.hardIrqCPU);
        out.writeInt(this.softIrqCPU);
        out.writeLong(this.totalMemory);
        out.writeLong(this.freeMemory);
        out.writeLong(this.bufferedMemory);
        out.writeLong(this.cachedMemory);
        out.writeLong(this.cachedSwapMemory);
        out.writeLong(this.receivedBytes);
        out.writeLong(this.transmittedBytes);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InstanceProfilingEvent) {
            InstanceProfilingEvent other = (InstanceProfilingEvent)obj;
            return super.equals(obj) && this.profilingInterval == other.profilingInterval && this.ioWaitCPU == other.ioWaitCPU && this.idleCPU == other.idleCPU && this.userCPU == other.userCPU && this.systemCPU == other.systemCPU && this.hardIrqCPU == other.hardIrqCPU && this.softIrqCPU == other.softIrqCPU && this.totalMemory == other.totalMemory && this.freeMemory == other.freeMemory && this.bufferedMemory == other.bufferedMemory && this.cachedMemory == other.cachedMemory && this.cachedSwapMemory == other.cachedSwapMemory && this.receivedBytes == other.receivedBytes && this.transmittedBytes == other.transmittedBytes;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long hashCode = (long)this.getJobID().hashCode() + this.getTimestamp() + this.getProfilingTimestamp();
        hashCode += (long)(this.profilingInterval + this.ioWaitCPU + this.idleCPU + this.userCPU + this.systemCPU + this.hardIrqCPU + this.softIrqCPU);
        hashCode += this.totalMemory + this.freeMemory + this.bufferedMemory + this.cachedMemory + this.cachedSwapMemory;
        hashCode ^= hashCode >>> 32;
        return (int)hashCode;
    }
}

