/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.impl.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.profiling.impl.types.InternalProfilingData;

public abstract class InternalExecutionVertexProfilingData
implements InternalProfilingData {
    private final JobID jobId;
    private final JobVertexID vertexId;
    private int subtask;
    private final ExecutionAttemptID executionId;

    public InternalExecutionVertexProfilingData() {
        this.jobId = new JobID();
        this.vertexId = new JobVertexID();
        this.executionId = new ExecutionAttemptID();
        this.subtask = -1;
    }

    public InternalExecutionVertexProfilingData(JobID jobId, JobVertexID vertexId, int subtask, ExecutionAttemptID executionId) {
        this.jobId = jobId;
        this.vertexId = vertexId;
        this.subtask = subtask;
        this.executionId = executionId;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public JobVertexID getVertexId() {
        return this.vertexId;
    }

    public int getSubtask() {
        return this.subtask;
    }

    public ExecutionAttemptID getExecutionAttemptId() {
        return this.executionId;
    }

    public void read(DataInputView in) throws IOException {
        this.jobId.read(in);
        this.vertexId.read(in);
        this.executionId.read(in);
        this.subtask = in.readInt();
    }

    public void write(DataOutputView out) throws IOException {
        this.jobId.write(out);
        this.vertexId.write(out);
        this.executionId.write(out);
        out.writeInt(this.subtask);
    }
}

