/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.plugable;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class DeserializationDelegate<T>
implements IOReadableWritable {
    private T instance;
    private final TypeSerializer<T> serializer;

    public DeserializationDelegate(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public void setInstance(T instance) {
        this.instance = instance;
    }

    public T getInstance() {
        return this.instance;
    }

    public void write(DataOutputView out) throws IOException {
        throw new IllegalStateException("Serialization method called on DeserializationDelegate.");
    }

    public void read(DataInputView in) throws IOException {
        this.instance = this.serializer.deserialize(this.instance, in);
    }
}

