/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.util.MutableObjectIterator;

public abstract class AbstractMutableHashTable<T> {
    protected final TypeSerializer<T> buildSideSerializer;
    protected final TypeComparator<T> buildSideComparator;

    public AbstractMutableHashTable(TypeSerializer<T> buildSideSerializer, TypeComparator<T> buildSideComparator) {
        this.buildSideSerializer = buildSideSerializer;
        this.buildSideComparator = buildSideComparator;
    }

    public TypeSerializer<T> getBuildSideSerializer() {
        return this.buildSideSerializer;
    }

    public TypeComparator<T> getBuildSideComparator() {
        return this.buildSideComparator;
    }

    public abstract void open();

    public abstract void close();

    public abstract void abort();

    public abstract void buildTable(MutableObjectIterator<T> var1) throws IOException;

    public abstract List<MemorySegment> getFreeMemory();

    public abstract void insert(T var1) throws IOException;

    public abstract void insertOrReplaceRecord(T var1, T var2) throws IOException;

    public abstract MutableObjectIterator<T> getEntryIterator();

    public abstract <PT> AbstractHashTableProber<PT, T> getProber(TypeComparator<PT> var1, TypePairComparator<PT, T> var2);
}

