/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.operators.util.JoinHashMap;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetBroker;
import org.apache.flink.runtime.iterative.task.AbstractIterativePactTask;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.ResettablePactDriver;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class JoinWithSolutionSetFirstDriver<IT1, IT2, OT>
implements ResettablePactDriver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    private PactTaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT1> hashTable;
    private JoinHashMap<IT1> objectMap;
    private TypeComparator<IT2> probeSideComparator;
    private TypePairComparator<IT2, IT1> pairComparator;
    private IT1 solutionSideRecord;
    private IT2 probeSideRecord;
    protected volatile boolean running;

    @Override
    public void setup(PactTaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<FlatJoinFunction<IT1, IT2, OT>> getStubType() {
        Class<FlatJoinFunction> clazz = FlatJoinFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize() {
        TypeComparator solutionSetComparator;
        TypeSerializer solutionSetSerializer;
        if (!(this.taskContext instanceof AbstractIterativePactTask)) throw new RuntimeException("The task context of this driver is no iterative task context.");
        AbstractIterativePactTask iterativeTaskContext = (AbstractIterativePactTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        Object table = SolutionSetBroker.instance().get(identifier);
        if (table instanceof CompactingHashTable) {
            this.hashTable = (CompactingHashTable)table;
            solutionSetSerializer = this.hashTable.getBuildSideSerializer();
            solutionSetComparator = this.hashTable.getBuildSideComparator().duplicate();
        } else {
            if (!(table instanceof JoinHashMap)) throw new RuntimeException("Unrecognized solution set index: " + table);
            this.objectMap = (JoinHashMap)table;
            solutionSetSerializer = this.objectMap.getBuildSerializer();
            solutionSetComparator = this.objectMap.getBuildComparator().duplicate();
        }
        TaskConfig config = this.taskContext.getTaskConfig();
        ClassLoader classLoader = this.taskContext.getUserCodeClassLoader();
        TypeSerializer probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        TypeComparatorFactory probeSideComparatorFactory = config.getDriverComparator(0, classLoader);
        this.probeSideComparator = probeSideComparatorFactory.createComparator();
        this.solutionSideRecord = solutionSetSerializer.createInstance();
        this.probeSideRecord = probeSideSerializer.createInstance();
        TypePairComparatorFactory factory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = factory.createComparator21(solutionSetComparator, this.probeSideComparator);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        FlatJoinFunction<IT1, IT2, OT> joinFunction = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        MutableObjectIterator probeSideInput = this.taskContext.getInput(0);
        Object probeSideRecord = this.probeSideRecord;
        if (this.hashTable != null) {
            CompactingHashTable<IT1> join = this.hashTable;
            AbstractHashTableProber prober = join.getProber((TypeComparator)this.probeSideComparator, (TypePairComparator)this.pairComparator);
            IT1 buildSideRecord = this.solutionSideRecord;
            while (this.running && (probeSideRecord = probeSideInput.next(probeSideRecord)) != null) {
                buildSideRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(probeSideRecord, buildSideRecord);
                joinFunction.join(buildSideRecord, probeSideRecord, collector);
            }
        } else if (this.objectMap != null) {
            JoinHashMap<IT1> hashTable = this.objectMap;
            JoinHashMap.Prober prober = this.objectMap.createProber(this.probeSideComparator, this.pairComparator);
            TypeSerializer buildSerializer = hashTable.getBuildSerializer();
            while (this.running && (probeSideRecord = probeSideInput.next(probeSideRecord)) != null) {
                Object match = prober.lookupMatch(probeSideRecord);
                joinFunction.join(buildSerializer.copy(match), probeSideRecord, collector);
            }
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

