/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.runtime.ExecutionMode;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.accumulators.AccumulatorEvent;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.client.AbstractJobResult;
import org.apache.flink.runtime.client.JobCancelResult;
import org.apache.flink.runtime.client.JobProgressResult;
import org.apache.flink.runtime.client.JobSubmissionResult;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.RecentJobEvent;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.instance.Hardware;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.instance.LocalInstanceManager;
import org.apache.flink.runtime.io.network.ConnectionInfoLookupResponse;
import org.apache.flink.runtime.io.network.channels.ChannelID;
import org.apache.flink.runtime.ipc.RPC;
import org.apache.flink.runtime.ipc.Server;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.EventCollector;
import org.apache.flink.runtime.jobmanager.accumulators.AccumulatorManager;
import org.apache.flink.runtime.jobmanager.archive.ArchiveListener;
import org.apache.flink.runtime.jobmanager.archive.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.web.WebInfoServer;
import org.apache.flink.runtime.protocols.AccumulatorProtocol;
import org.apache.flink.runtime.protocols.ChannelLookupProtocol;
import org.apache.flink.runtime.protocols.ExtendedManagementProtocol;
import org.apache.flink.runtime.protocols.InputSplitProviderProtocol;
import org.apache.flink.runtime.protocols.JobManagerProtocol;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.types.IntegerRecord;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.SerializableArrayList;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager
implements ExtendedManagementProtocol,
InputSplitProviderProtocol,
JobManagerProtocol,
ChannelLookupProtocol,
JobStatusListener,
AccumulatorProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    private static final int FAILURE_RETURN_CODE = 1;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2 * Hardware.getNumberCPUCores(), ExecutorThreadFactory.INSTANCE);
    private final Server jobManagerServer;
    private final InstanceManager instanceManager;
    private final Scheduler scheduler;
    private final ConcurrentHashMap<JobID, ExecutionGraph> currentJobs;
    private final EventCollector eventCollector;
    private final ArchiveListener archive;
    private final AccumulatorManager accumulatorManager;
    private final int recommendedClientPollingInterval;
    private final int defaultExecutionRetries;
    private final long delayBetweenRetries;
    private final AtomicBoolean isShutdownInProgress = new AtomicBoolean(false);
    private volatile boolean isShutDown;
    private WebInfoServer server;
    private BlobLibraryCacheManager libraryCacheManager;

    public JobManager(ExecutionMode executionMode) throws Exception {
        String ipcAddressString = GlobalConfiguration.getString((String)"jobmanager.rpc.address", null);
        InetAddress ipcAddress = null;
        if (ipcAddressString != null) {
            try {
                ipcAddress = InetAddress.getByName(ipcAddressString);
            }
            catch (UnknownHostException e) {
                throw new Exception("Cannot convert " + ipcAddressString + " to an IP address: " + e.getMessage(), e);
            }
        }
        int ipcPort = GlobalConfiguration.getInteger((String)"jobmanager.rpc.port", (int)6123);
        this.recommendedClientPollingInterval = GlobalConfiguration.getInteger((String)"jobclient.polling.interval", (int)2);
        this.defaultExecutionRetries = GlobalConfiguration.getInteger((String)"execution-retries.default", (int)0);
        this.delayBetweenRetries = 2L * GlobalConfiguration.getLong((String)"jobmanager.max-heartbeat-delay-before-failure.msecs", (long)30000L);
        this.eventCollector = new EventCollector(this.recommendedClientPollingInterval);
        this.libraryCacheManager = new BlobLibraryCacheManager(new BlobServer(), GlobalConfiguration.getConfiguration());
        int archived_items = GlobalConfiguration.getInteger((String)"jobmanager.web.history", (int)5);
        if (archived_items > 0) {
            this.archive = new MemoryArchivist(archived_items);
            this.eventCollector.registerArchivist(this.archive);
        } else {
            this.archive = null;
        }
        this.currentJobs = new ConcurrentHashMap();
        this.accumulatorManager = new AccumulatorManager(Math.min(1, archived_items));
        InetSocketAddress rpcServerAddress = new InetSocketAddress(ipcAddress, ipcPort);
        try {
            int handlerCount = GlobalConfiguration.getInteger((String)"jobmanager.rpc.numhandler", (int)8);
            this.jobManagerServer = RPC.getServer(this, rpcServerAddress.getHostName(), rpcServerAddress.getPort(), handlerCount);
            this.jobManagerServer.start();
        }
        catch (IOException e) {
            throw new Exception("Cannot start RPC server: " + e.getMessage(), e);
        }
        LOG.info("Starting job manager in " + (Object)((Object)executionMode) + " mode");
        if (executionMode == ExecutionMode.LOCAL) {
            int numTaskManagers = GlobalConfiguration.getInteger((String)"localinstancemanager.numtaskmanager", (int)1);
            this.instanceManager = new LocalInstanceManager(numTaskManagers);
        } else if (executionMode == ExecutionMode.CLUSTER) {
            this.instanceManager = new InstanceManager();
        } else {
            throw new IllegalArgumentException("ExecutionMode");
        }
        this.scheduler = new Scheduler(this.executorService);
        this.instanceManager.addInstanceListener(this.scheduler);
    }

    public void shutdown() {
        if (!this.isShutdownInProgress.compareAndSet(false, true)) {
            return;
        }
        for (ExecutionGraph e : this.currentJobs.values()) {
            e.fail(new Exception("The JobManager is shutting down."));
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Shutdown of executor thread pool interrupted", (Throwable)e);
            }
            this.executorService.shutdownNow();
        }
        if (this.instanceManager != null) {
            this.instanceManager.shutdown();
        }
        if (this.libraryCacheManager != null) {
            try {
                this.libraryCacheManager.shutdown();
            }
            catch (IOException e) {
                LOG.warn("Could not properly shutdown the library cache manager.", (Throwable)e);
            }
        }
        if (this.jobManagerServer != null) {
            this.jobManagerServer.stop();
        }
        if (this.eventCollector != null) {
            this.eventCollector.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e1) {
                throw new RuntimeException("Error shtopping the web-info-server.", e1);
            }
        }
        this.isShutDown = true;
        LOG.debug("Shutdown of job manager completed");
    }

    @Override
    public JobSubmissionResult submitJob(JobGraph job) throws IOException {
        if (job == null) {
            return new JobSubmissionResult(AbstractJobResult.ReturnCode.ERROR, "Submitted job is null!");
        }
        if (job.getNumberOfVertices() == 0) {
            return new JobSubmissionResult(AbstractJobResult.ReturnCode.ERROR, "Job is empty.");
        }
        ExecutionGraph executionGraph = null;
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Received job %s (%s)", job.getJobID(), job.getName()));
            }
            this.libraryCacheManager.registerJob(job.getJobID(), job.getUserJarBlobKeys());
            ClassLoader userCodeLoader = this.libraryCacheManager.getClassLoader(job.getJobID());
            if (userCodeLoader == null) {
                throw new JobException("The user code class loader could not be initialized.");
            }
            executionGraph = this.currentJobs.get(job.getJobID());
            if (executionGraph == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Creating new execution graph for job " + job.getJobID() + " (" + job.getName() + ')');
                }
                executionGraph = new ExecutionGraph(job.getJobID(), job.getName(), job.getJobConfiguration(), job.getUserJarBlobKeys(), userCodeLoader, this.executorService);
                executionGraph.setNumberOfRetriesLeft(job.getNumberOfExecutionRetries() >= 0 ? job.getNumberOfExecutionRetries() : this.defaultExecutionRetries);
                executionGraph.setDelayBeforeRetrying(this.delayBetweenRetries);
                ExecutionGraph previous = this.currentJobs.putIfAbsent(job.getJobID(), executionGraph);
                if (previous != null) {
                    throw new JobException("Concurrent submission of a job with the same jobId: " + job.getJobID());
                }
            } else if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Found existing execution graph for id %s, attaching this job.", job.getJobID()));
            }
            executionGraph.registerJobStatusListener(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Running master initialization of job %s (%s)", job.getJobID(), job.getName()));
            }
            for (AbstractJobVertex vertex : job.getVertices()) {
                String executableClass = vertex.getInvokableClassName();
                if (executableClass == null || executableClass.length() == 0) {
                    throw new JobException(String.format("The vertex %s (%s) has no invokable class.", vertex.getID(), vertex.getName()));
                }
                vertex.initializeOnMaster(userCodeLoader);
            }
            List<AbstractJobVertex> topoSorted = job.getVerticesSortedTopologicallyFromSources();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Adding %d vertices from job graph %s (%s)", topoSorted.size(), job.getJobID(), job.getName()));
            }
            executionGraph.attachJobGraph(topoSorted);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Successfully created execution graph from job graph %s (%s)", job.getJobID(), job.getName()));
            }
            executionGraph.setQueuedSchedulingAllowed(job.getAllowQueuedScheduling());
            if (this.eventCollector != null) {
                this.eventCollector.registerJob(executionGraph, false, System.currentTimeMillis());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Scheduling job " + job.getName());
            }
            executionGraph.scheduleForExecution(this.scheduler);
            return new JobSubmissionResult(AbstractJobResult.ReturnCode.SUCCESS, null);
        }
        catch (Throwable t) {
            LOG.error("Job submission failed.", t);
            if (executionGraph != null) {
                executionGraph.fail(t);
                try {
                    executionGraph.waitForJobEnd(10000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while waiting for job to finish canceling.");
                }
            }
            if (this.currentJobs.contains(job.getJobID())) {
                this.currentJobs.remove(job.getJobID());
                this.libraryCacheManager.unregisterJob(job.getJobID());
            }
            return new JobSubmissionResult(AbstractJobResult.ReturnCode.ERROR, StringUtils.stringifyException((Throwable)t));
        }
    }

    @Override
    public JobCancelResult cancelJob(JobID jobID) throws IOException {
        LOG.info("Trying to cancel job with ID " + jobID);
        final ExecutionGraph eg = this.currentJobs.get(jobID);
        if (eg == null) {
            LOG.info("No job found with ID " + jobID);
            return new JobCancelResult(AbstractJobResult.ReturnCode.ERROR, "Cannot find job with ID " + jobID);
        }
        Runnable cancelJobRunnable = new Runnable(){

            @Override
            public void run() {
                eg.cancel();
            }
        };
        eg.execute(cancelJobRunnable);
        return new JobCancelResult(AbstractJobResult.ReturnCode.SUCCESS, null);
    }

    @Override
    public boolean updateTaskExecutionState(TaskExecutionState executionState) throws IOException {
        Preconditions.checkNotNull((Object)executionState);
        ExecutionGraph eg = this.currentJobs.get(executionState.getJobID());
        if (eg == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Orphaned execution task: UpdateTaskExecutionState call cannot find execution graph for ID " + executionState.getJobID() + " to change state to " + (Object)((Object)executionState.getExecutionState()));
            }
            return false;
        }
        return eg.updateState(executionState);
    }

    @Override
    public InputSplit requestNextInputSplit(JobID jobID, JobVertexID vertexId, ExecutionAttemptID executionAttempt) throws IOException {
        ExecutionGraph graph = this.currentJobs.get(jobID);
        if (graph == null) {
            LOG.error("Cannot find execution graph to job ID " + jobID);
            return null;
        }
        ExecutionJobVertex vertex = graph.getJobVertex(vertexId);
        if (vertex == null) {
            LOG.error("Cannot find execution vertex for vertex ID " + vertexId);
            return null;
        }
        InputSplitAssigner splitAssigner = vertex.getSplitAssigner();
        if (splitAssigner == null) {
            LOG.error("No InputSplitAssigner for vertex ID " + vertexId);
            return null;
        }
        String host = null;
        Execution execution = graph.getRegisteredExecutions().get(executionAttempt);
        if (execution == null) {
            LOG.error("Can not find Execution for attempt " + executionAttempt);
        } else {
            AllocatedSlot slot = execution.getAssignedResource();
            if (slot != null) {
                host = slot.getInstance().getInstanceConnectionInfo().getHostname();
            }
        }
        return splitAssigner.getNextInputSplit(host);
    }

    @Override
    public void jobStatusHasChanged(ExecutionGraph executionGraph, JobStatus newJobStatus, String optionalMessage) {
        JobID jid = executionGraph.getJobID();
        if (LOG.isInfoEnabled()) {
            String message = optionalMessage == null ? "." : ": " + optionalMessage;
            LOG.info(String.format("Job %s (%s) switched to %s%s", new Object[]{jid, executionGraph.getJobName(), newJobStatus, message}));
        }
        if (newJobStatus.isTerminalState()) {
            this.currentJobs.remove(jid);
            try {
                this.libraryCacheManager.unregisterJob(jid);
            }
            catch (Throwable t) {
                LOG.warn("Could not properly unregister job " + jid + " from the library cache.");
            }
        }
    }

    @Override
    public JobProgressResult getJobProgress(JobID jobID) throws IOException {
        if (this.eventCollector == null) {
            return new JobProgressResult(AbstractJobResult.ReturnCode.ERROR, "JobManager does not support progress reports for jobs", null);
        }
        SerializableArrayList<AbstractEvent> eventList = new SerializableArrayList<AbstractEvent>();
        this.eventCollector.getEventsForJob(jobID, eventList, false);
        return new JobProgressResult(AbstractJobResult.ReturnCode.SUCCESS, null, eventList);
    }

    @Override
    public ConnectionInfoLookupResponse lookupConnectionInfo(InstanceConnectionInfo caller, JobID jobID, ChannelID sourceChannelID) {
        ExecutionGraph eg = this.currentJobs.get(jobID);
        if (eg == null) {
            LOG.error("Cannot find execution graph to job ID " + jobID);
            return ConnectionInfoLookupResponse.createReceiverNotFound();
        }
        return eg.lookupConnectionInfoAndDeployReceivers(caller, sourceChannelID);
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    public InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    @Override
    public IntegerRecord getRecommendedPollingInterval() throws IOException {
        return new IntegerRecord(this.recommendedClientPollingInterval);
    }

    @Override
    public List<RecentJobEvent> getRecentJobs() throws IOException {
        SerializableArrayList<RecentJobEvent> eventList = new SerializableArrayList<RecentJobEvent>();
        if (this.eventCollector == null) {
            throw new IOException("No instance of the event collector found");
        }
        this.eventCollector.getRecentJobs(eventList);
        return eventList;
    }

    @Override
    public List<AbstractEvent> getEvents(JobID jobID) throws IOException {
        SerializableArrayList<AbstractEvent> eventList = new SerializableArrayList<AbstractEvent>();
        if (this.eventCollector == null) {
            throw new IOException("No instance of the event collector found");
        }
        this.eventCollector.getEventsForJob(jobID, eventList, true);
        return eventList;
    }

    @Override
    public int getTotalNumberOfRegisteredSlots() {
        return this.getInstanceManager().getTotalNumberOfSlots();
    }

    @Override
    public int getNumberOfSlotsAvailableToScheduler() {
        return this.scheduler.getNumberOfAvailableSlots();
    }

    public void startInfoServer() {
        Configuration config = GlobalConfiguration.getConfiguration();
        try {
            int port = config.getInteger("jobmanager.web.port", 8081);
            this.server = new WebInfoServer(config, port, this);
            this.server.start();
        }
        catch (FileNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Cannot instantiate info server: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<RecentJobEvent> getOldJobs() throws IOException {
        if (this.archive == null) {
            throw new IOException("No instance of the event collector found");
        }
        return this.archive.getJobs();
    }

    public ArchiveListener getArchive() {
        return this.archive;
    }

    public int getNumberOfTaskManagers() {
        return this.instanceManager.getNumberOfRegisteredTaskManagers();
    }

    public Map<InstanceID, Instance> getInstances() {
        return this.instanceManager.getAllRegisteredInstances();
    }

    @Override
    public void reportAccumulatorResult(AccumulatorEvent accumulatorEvent) throws IOException {
        this.accumulatorManager.processIncomingAccumulators(accumulatorEvent.getJobID(), accumulatorEvent.getAccumulators(this.libraryCacheManager.getClassLoader(accumulatorEvent.getJobID())));
    }

    @Override
    public AccumulatorEvent getAccumulatorResults(JobID jobID) throws IOException {
        return new AccumulatorEvent(jobID, this.accumulatorManager.getJobAccumulators(jobID));
    }

    public Map<String, Accumulator<?, ?>> getAccumulators(JobID jobID) {
        return this.accumulatorManager.getJobAccumulators(jobID);
    }

    public Map<JobID, ExecutionGraph> getCurrentJobs() {
        return Collections.unmodifiableMap(this.currentJobs);
    }

    public ExecutionGraph getRecentExecutionGraph(JobID jobID) throws IOException {
        ExecutionGraph eg = this.currentJobs.get(jobID);
        if (eg == null && (eg = this.eventCollector.getManagementGraph(jobID)) == null && this.archive != null) {
            eg = this.archive.getExecutionGraph(jobID);
        }
        if (eg == null) {
            throw new IOException("Cannot find execution graph for job with ID " + jobID);
        }
        return eg;
    }

    @Override
    public boolean sendHeartbeat(InstanceID taskManagerId) {
        return this.instanceManager.reportHeartBeat(taskManagerId);
    }

    @Override
    public InstanceID registerTaskManager(InstanceConnectionInfo instanceConnectionInfo, HardwareDescription hardwareDescription, int numberOfSlots) {
        if (this.instanceManager != null && this.scheduler != null) {
            return this.instanceManager.registerTaskManager(instanceConnectionInfo, hardwareDescription, numberOfSlots);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object w;
        try {
            JobManager jobManager = JobManager.initialize(args);
            jobManager.startInfoServer();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        Object object = w = new Object();
        synchronized (object) {
            try {
                w.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static JobManager initialize(String[] args) throws Exception {
        OptionBuilder.withArgName((String)"config directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify configuration directory.");
        Option configDirOpt = OptionBuilder.create((String)"configDir");
        OptionBuilder.withArgName((String)"execution mode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify execution mode.");
        Option executionModeOpt = OptionBuilder.create((String)"executionMode");
        Options options = new Options();
        options.addOption(configDirOpt);
        options.addOption(executionModeOpt);
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.error("CLI Parsing failed. Reason: " + e.getMessage());
            System.exit(1);
        }
        String configDir = line.getOptionValue(configDirOpt.getOpt(), null);
        String executionModeName = line.getOptionValue(executionModeOpt.getOpt(), "local");
        ExecutionMode executionMode = null;
        if ("local".equals(executionModeName)) {
            executionMode = ExecutionMode.LOCAL;
        } else if ("cluster".equals(executionModeName)) {
            executionMode = ExecutionMode.CLUSTER;
        } else {
            System.err.println("Unrecognized execution mode: " + executionModeName);
            System.exit(1);
        }
        EnvironmentInformation.logEnvironmentInfo(LOG, "JobManager");
        GlobalConfiguration.loadConfiguration((String)configDir);
        JobManager jobManager = new JobManager(executionMode);
        Configuration infoserverConfig = GlobalConfiguration.getConfiguration();
        if (configDir != null && new File(configDir).isDirectory()) {
            infoserverConfig.setString("flink.base.dir.path", configDir + "/..");
        }
        GlobalConfiguration.includeConfiguration((Configuration)infoserverConfig);
        return jobManager;
    }

    @Override
    public int getBlobServerPort() {
        return this.libraryCacheManager.getBlobServerPort();
    }
}

