/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStream;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStream;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.types.StringValue;

public class JobGraph
implements IOReadableWritable {
    private final Map<JobVertexID, AbstractJobVertex> taskVertices = new LinkedHashMap<JobVertexID, AbstractJobVertex>();
    private final Configuration jobConfiguration = new Configuration();
    private final transient List<Path> userJars = new ArrayList<Path>();
    private final List<BlobKey> userJarBlobKeys = new ArrayList<BlobKey>();
    private final JobID jobID;
    private String jobName;
    private int numExecutionRetries;
    private boolean allowQueuedScheduling;

    public JobGraph() {
        this((String)null);
    }

    public JobGraph(String jobName) {
        this(null, jobName);
    }

    public JobGraph(JobID jobId, String jobName) {
        this.jobID = jobId == null ? new JobID() : jobId;
        this.jobName = jobName == null ? "(unnamed job)" : jobName;
    }

    public JobGraph(AbstractJobVertex ... vertices) {
        this((String)null, vertices);
    }

    public JobGraph(String jobName, AbstractJobVertex ... vertices) {
        this(null, jobName, vertices);
    }

    public JobGraph(JobID jobId, String jobName, AbstractJobVertex ... vertices) {
        this(jobId, jobName);
        for (AbstractJobVertex vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getName() {
        return this.jobName;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        if (numberOfExecutionRetries < -1) {
            throw new IllegalArgumentException("The number of execution retries must be non-negative, or -1 (use system default)");
        }
        this.numExecutionRetries = numberOfExecutionRetries;
    }

    public int getNumberOfExecutionRetries() {
        return this.numExecutionRetries;
    }

    public void setAllowQueuedScheduling(boolean allowQueuedScheduling) {
        this.allowQueuedScheduling = allowQueuedScheduling;
    }

    public boolean getAllowQueuedScheduling() {
        return this.allowQueuedScheduling;
    }

    public void addVertex(AbstractJobVertex vertex) {
        JobVertexID id = vertex.getID();
        AbstractJobVertex previous = this.taskVertices.put(id, vertex);
        if (previous != null) {
            this.taskVertices.put(id, previous);
            throw new IllegalArgumentException("The JobGraph already contains a vertex with that id.");
        }
    }

    public Iterable<AbstractJobVertex> getVertices() {
        return this.taskVertices.values();
    }

    public AbstractJobVertex[] getVerticesAsArray() {
        return this.taskVertices.values().toArray(new AbstractJobVertex[this.taskVertices.size()]);
    }

    public int getNumberOfVertices() {
        return this.taskVertices.size();
    }

    public AbstractJobVertex findVertexByID(JobVertexID id) {
        return this.taskVertices.get(id);
    }

    public List<AbstractJobVertex> getVerticesSortedTopologicallyFromSources() throws InvalidProgramException {
        if (this.taskVertices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractJobVertex> sorted = new ArrayList<AbstractJobVertex>(this.taskVertices.size());
        LinkedHashSet<AbstractJobVertex> remaining = new LinkedHashSet<AbstractJobVertex>(this.taskVertices.values());
        Iterator iter = remaining.iterator();
        while (iter.hasNext()) {
            AbstractJobVertex vertex = (AbstractJobVertex)iter.next();
            if (!vertex.hasNoConnectedInputs()) continue;
            sorted.add(vertex);
            iter.remove();
        }
        int startNodePos = 0;
        while (!remaining.isEmpty()) {
            if (startNodePos >= sorted.size()) {
                throw new InvalidProgramException("The job graph is cyclic.");
            }
            AbstractJobVertex current = (AbstractJobVertex)sorted.get(startNodePos++);
            this.addNodesThatHaveNoNewPredecessors(current, sorted, remaining);
        }
        return sorted;
    }

    private void addNodesThatHaveNoNewPredecessors(AbstractJobVertex start, List<AbstractJobVertex> target, Set<AbstractJobVertex> remaining) {
        for (IntermediateDataSet dataSet : start.getProducedDataSets()) {
            for (JobEdge edge : dataSet.getConsumers()) {
                AbstractJobVertex v = edge.getTarget();
                if (!remaining.contains(v)) continue;
                boolean hasNewPredecessors = false;
                for (JobEdge e : v.getInputs()) {
                    IntermediateDataSet source;
                    if (e == edge || !remaining.contains((source = e.getSource()).getProducer())) continue;
                    hasNewPredecessors = true;
                    break;
                }
                if (hasNewPredecessors) continue;
                target.add(v);
                remaining.remove(v);
                this.addNodesThatHaveNoNewPredecessors(v, target, remaining);
            }
        }
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        this.jobName = StringValue.readString((DataInput)in);
        this.jobConfiguration.read(in);
        this.numExecutionRetries = in.readInt();
        this.allowQueuedScheduling = in.readBoolean();
        int numVertices = in.readInt();
        ObjectInputStream ois = new ObjectInputStream((InputStream)new DataInputViewStream(in));
        for (int i = 0; i < numVertices; ++i) {
            try {
                AbstractJobVertex vertex = (AbstractJobVertex)ois.readObject();
                this.taskVertices.put(vertex.getID(), vertex);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        ois.close();
        this.readJarBlobKeys(in);
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        StringValue.writeString((CharSequence)this.jobName, (DataOutput)out);
        this.jobConfiguration.write(out);
        out.writeInt(this.numExecutionRetries);
        out.writeBoolean(this.allowQueuedScheduling);
        out.writeInt(this.taskVertices.size());
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new DataOutputViewStream(out));
        for (AbstractJobVertex vertex : this.taskVertices.values()) {
            oos.writeObject(vertex);
        }
        oos.close();
        this.writeJarBlobKeys(out);
    }

    private void writeJarBlobKeys(DataOutputView out) throws IOException {
        out.writeInt(this.userJarBlobKeys.size());
        for (BlobKey userJarBlobKey : this.userJarBlobKeys) {
            userJarBlobKey.write(out);
        }
    }

    private void readJarBlobKeys(DataInputView in) throws IOException {
        int numberOfBlobKeys = in.readInt();
        for (int i = 0; i < numberOfBlobKeys; ++i) {
            BlobKey key = new BlobKey();
            key.read(in);
            this.userJarBlobKeys.add(key);
        }
    }

    public void addJar(Path jar) {
        if (jar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJars.contains(jar)) {
            this.userJars.add(jar);
        }
    }

    public List<BlobKey> getUserJarBlobKeys() {
        return this.userJarBlobKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadRequiredJarFiles(InetSocketAddress serverAddress) throws IOException {
        if (this.userJars.isEmpty()) {
            return;
        }
        BlobClient bc = null;
        try {
            bc = new BlobClient(serverAddress);
            for (Path jar : this.userJars) {
                FileSystem fs = jar.getFileSystem();
                FSDataInputStream is = null;
                try {
                    is = fs.open(jar);
                    BlobKey key = bc.put((InputStream)is);
                    this.userJarBlobKeys.add(key);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        finally {
            if (bc != null) {
                bc.close();
            }
        }
    }
}

