/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;

public class IntermediateDataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IntermediateDataSetID id;
    private final AbstractJobVertex producer;
    private final List<JobEdge> consumers = new ArrayList<JobEdge>();

    public IntermediateDataSet(AbstractJobVertex producer) {
        this(new IntermediateDataSetID(), producer);
    }

    public IntermediateDataSet(IntermediateDataSetID id, AbstractJobVertex producer) {
        if (id == null || producer == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.producer = producer;
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public AbstractJobVertex getProducer() {
        return this.producer;
    }

    public List<JobEdge> getConsumers() {
        return this.consumers;
    }

    public void addConsumer(JobEdge edge) {
        this.consumers.add(edge);
    }

    public String toString() {
        return "Intermediate Data Set (" + this.id + ")";
    }
}

