/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.task;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.runtime.event.task.AbstractTaskEvent;
import org.apache.flink.runtime.io.network.api.MutableRecordReader;
import org.apache.flink.runtime.iterative.event.AllWorkersDoneEvent;
import org.apache.flink.runtime.iterative.event.TerminationEvent;
import org.apache.flink.runtime.iterative.event.WorkerDoneEvent;
import org.apache.flink.runtime.iterative.task.SyncEventHandler;
import org.apache.flink.runtime.iterative.task.Terminable;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.RegularPactTask;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.types.IntegerRecord;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterationSynchronizationSinkTask
extends AbstractInvokable
implements Terminable {
    private static final Logger log = LoggerFactory.getLogger(IterationSynchronizationSinkTask.class);
    private MutableRecordReader<IntegerRecord> headEventReader;
    private SyncEventHandler eventHandler;
    private ConvergenceCriterion<Value> convergenceCriterion;
    private Map<String, Aggregator<?>> aggregators;
    private String convergenceAggregatorName;
    private int currentIteration = 1;
    private int maxNumberOfIterations;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    @Override
    public void registerInputOutput() {
        this.headEventReader = new MutableRecordReader(this);
    }

    @Override
    public void invoke() throws Exception {
        TaskConfig taskConfig = new TaskConfig(this.getTaskConfiguration());
        this.aggregators = new HashMap();
        for (AggregatorWithName<?> aggWithName : taskConfig.getIterationAggregators(this.getUserCodeClassLoader())) {
            this.aggregators.put(aggWithName.getName(), aggWithName.getAggregator());
        }
        if (taskConfig.usesConvergenceCriterion()) {
            this.convergenceCriterion = taskConfig.getConvergenceCriterion(this.getUserCodeClassLoader());
            this.convergenceAggregatorName = taskConfig.getConvergenceCriterionAggregatorName();
            Preconditions.checkNotNull((Object)this.convergenceAggregatorName);
        }
        this.maxNumberOfIterations = taskConfig.getNumberOfIterations();
        int numEventsTillEndOfSuperstep = taskConfig.getNumberOfEventsUntilInterruptInIterativeGate(0);
        this.eventHandler = new SyncEventHandler(numEventsTillEndOfSuperstep, this.aggregators, this.getEnvironment().getUserClassLoader());
        this.headEventReader.subscribeToEvent(this.eventHandler, WorkerDoneEvent.class);
        IntegerRecord dummy = new IntegerRecord();
        while (!this.terminationRequested()) {
            if (log.isInfoEnabled()) {
                log.info(this.formatLogString("starting iteration [" + this.currentIteration + "]"));
            }
            this.readHeadEventChannel(dummy);
            if (log.isInfoEnabled()) {
                log.info(this.formatLogString("finishing iteration [" + this.currentIteration + "]"));
            }
            if (this.checkForConvergence()) {
                if (log.isInfoEnabled()) {
                    log.info(this.formatLogString("signaling that all workers are to terminate in iteration [" + this.currentIteration + "]"));
                }
                this.requestTermination();
                this.sendToAllWorkers(new TerminationEvent());
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info(this.formatLogString("signaling that all workers are done in iteration [" + this.currentIteration + "]"));
            }
            AllWorkersDoneEvent allWorkersDoneEvent = new AllWorkersDoneEvent(this.aggregators);
            this.sendToAllWorkers(allWorkersDoneEvent);
            for (Aggregator<?> agg : this.aggregators.values()) {
                agg.reset();
            }
            ++this.currentIteration;
        }
    }

    private boolean checkForConvergence() {
        if (this.maxNumberOfIterations == this.currentIteration) {
            if (log.isInfoEnabled()) {
                log.info(this.formatLogString("maximum number of iterations [" + this.currentIteration + "] reached, terminating..."));
            }
            return true;
        }
        if (this.convergenceAggregatorName != null) {
            Aggregator<?> aggregator = this.aggregators.get(this.convergenceAggregatorName);
            if (aggregator == null) {
                throw new RuntimeException("Error: Aggregator for convergence criterion was null.");
            }
            Value aggregate = aggregator.getAggregate();
            if (this.convergenceCriterion.isConverged(this.currentIteration, aggregate)) {
                if (log.isInfoEnabled()) {
                    log.info(this.formatLogString("convergence reached after [" + this.currentIteration + "] iterations, terminating..."));
                }
                return true;
            }
        }
        return false;
    }

    private void readHeadEventChannel(IntegerRecord rec) throws IOException {
        block3: {
            this.eventHandler.resetEndOfSuperstep();
            try {
                if (this.headEventReader.next(rec)) {
                    throw new RuntimeException("Synchronization task must not see any records!");
                }
            }
            catch (InterruptedException iex) {
                if (this.eventHandler.isEndOfSuperstep()) break block3;
                throw new RuntimeException("Event handler interrupted without reaching end-of-superstep.");
            }
        }
    }

    private void sendToAllWorkers(AbstractTaskEvent event) throws IOException, InterruptedException {
        this.headEventReader.publishEvent(event);
    }

    private String formatLogString(String message) {
        return RegularPactTask.constructLogString(message, this.getEnvironment().getTaskName(), this);
    }

    @Override
    public boolean terminationRequested() {
        return this.terminated.get();
    }

    @Override
    public void requestTermination() {
        this.terminated.set(true);
    }
}

