/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.channels;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.event.task.AbstractTaskEvent;
import org.apache.flink.runtime.io.network.Buffer;
import org.apache.flink.runtime.io.network.Envelope;
import org.apache.flink.runtime.io.network.bufferprovider.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.bufferprovider.BufferProvider;
import org.apache.flink.runtime.io.network.channels.BufferOrEvent;
import org.apache.flink.runtime.io.network.channels.Channel;
import org.apache.flink.runtime.io.network.channels.ChannelCloseEvent;
import org.apache.flink.runtime.io.network.channels.ChannelID;
import org.apache.flink.runtime.io.network.channels.ChannelType;
import org.apache.flink.runtime.io.network.channels.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.gates.InputChannelResult;
import org.apache.flink.runtime.io.network.gates.InputGate;
import org.apache.flink.runtime.io.network.serialization.AdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.serialization.RecordDeserializer;
import org.apache.flink.runtime.jobgraph.JobID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputChannel<T extends IOReadableWritable>
extends Channel
implements BufferProvider {
    private final InputGate<T> inputGate;
    private static final Logger LOG = LoggerFactory.getLogger(InputChannel.class);
    private final RecordDeserializer<T> deserializer;
    private Buffer dataBuffer;
    private AbstractTaskEvent currentEvent;
    private volatile IOException ioException;
    private long amountOfDataTransmitted;
    private volatile boolean weClosedChannel;
    private volatile boolean senderClosedChannel;
    private int lastReceivedEnvelope = -1;
    private boolean destroyCalled = false;
    private Queue<Envelope> queuedEnvelopes = new ArrayDeque<Envelope>();
    private Iterator<AbstractEvent> pendingEvents;

    public InputChannel(InputGate<T> inputGate, int channelIndex, ChannelID channelID, ChannelID connectedChannelID, ChannelType type) {
        super(channelIndex, channelID, connectedChannelID, type);
        this.inputGate = inputGate;
        this.deserializer = new AdaptiveSpanningRecordDeserializer();
    }

    public InputGate<T> getInputGate() {
        return this.inputGate;
    }

    @Override
    public boolean isInputChannel() {
        return true;
    }

    @Override
    public JobID getJobID() {
        return this.inputGate.getJobID();
    }

    public InputChannelResult readRecord(T target) throws IOException {
        RecordDeserializer.DeserializationResult deserializationResult;
        if (this.dataBuffer == null) {
            if (this.isClosed()) {
                return InputChannelResult.END_OF_STREAM;
            }
            BufferOrEvent boe = this.getNextBufferOrEvent();
            if (boe == null) {
                throw new IllegalStateException("Input channel was queries for data even though none was announced available.");
            }
            if (boe.isEvent()) {
                if (this.deserializer.hasUnfinishedData()) {
                    throw new IllegalStateException("Channel received an event before completing the current partial record.");
                }
                AbstractEvent evt = boe.getEvent();
                if (evt.getClass() == ChannelCloseEvent.class) {
                    this.senderClosedChannel = true;
                    try {
                        this.close();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                    return InputChannelResult.END_OF_STREAM;
                }
                if (evt.getClass() == EndOfSuperstepEvent.class) {
                    return InputChannelResult.END_OF_SUPERSTEP;
                }
                if (evt instanceof AbstractTaskEvent) {
                    this.currentEvent = (AbstractTaskEvent)evt;
                    return InputChannelResult.TASK_EVENT;
                }
                LOG.error("Received unknown event: " + evt);
                return InputChannelResult.NONE;
            }
            this.dataBuffer = boe.getBuffer();
            this.deserializer.setNextMemorySegment(this.dataBuffer.getMemorySegment(), this.dataBuffer.size());
        }
        if ((deserializationResult = this.deserializer.getNextRecord(target)).isBufferConsumed()) {
            this.releasedConsumedReadBuffer(this.dataBuffer);
            this.dataBuffer = null;
        }
        if (deserializationResult == RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER) {
            return InputChannelResult.INTERMEDIATE_RECORD_FROM_BUFFER;
        }
        if (deserializationResult == RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER) {
            return InputChannelResult.LAST_RECORD_FROM_BUFFER;
        }
        if (deserializationResult == RecordDeserializer.DeserializationResult.PARTIAL_RECORD) {
            return InputChannelResult.NONE;
        }
        throw new IllegalStateException();
    }

    @Override
    public ChannelType getChannelType() {
        return null;
    }

    @Override
    public boolean isClosed() throws IOException {
        if (this.ioException != null) {
            throw new IOException("An error occurred in the channel: " + this.ioException.getMessage(), this.ioException);
        }
        return this.weClosedChannel && this.senderClosedChannel;
    }

    public void close() throws IOException, InterruptedException {
        if (this.weClosedChannel) {
            return;
        }
        this.weClosedChannel = true;
        this.deserializer.clear();
        if (this.dataBuffer != null) {
            this.releasedConsumedReadBuffer(this.dataBuffer);
            this.dataBuffer = null;
        }
        while (!this.senderClosedChannel) {
            BufferOrEvent next = this.getNextBufferOrEvent();
            if (next != null) {
                if (next.isEvent()) {
                    if (!(next.getEvent() instanceof ChannelCloseEvent)) continue;
                    this.senderClosedChannel = true;
                    continue;
                }
                this.releasedConsumedReadBuffer(next.getBuffer());
                continue;
            }
            Thread.sleep(200L);
        }
        this.transferEventToOutputChannel(new ChannelCloseEvent());
    }

    private void releasedConsumedReadBuffer(Buffer buffer) {
        this.amountOfDataTransmitted += (long)buffer.size();
        buffer.recycleBuffer();
    }

    public void notifyGateThatInputIsAvailable() {
        this.getInputGate().notifyRecordIsAvailable(this.getIndex());
    }

    @Override
    public void transferEvent(AbstractEvent event) throws IOException, InterruptedException {
        this.transferEventToOutputChannel(event);
    }

    public void reportIOException(IOException ioe) {
        this.ioException = ioe;
    }

    @Override
    public void releaseAllResources() {
        this.senderClosedChannel = true;
        this.deserializer.clear();
        Buffer buf = this.dataBuffer;
        if (buf != null) {
            buf.recycleBuffer();
            this.dataBuffer = null;
        }
    }

    public void notifyDataUnitConsumed() {
        this.getInputGate().notifyDataUnitConsumed(this.getIndex());
    }

    public AbstractTaskEvent getCurrentEvent() {
        AbstractTaskEvent e = this.currentEvent;
        this.currentEvent = null;
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueEnvelope(Envelope envelope) {
        int sequenceNumber = envelope.getSequenceNumber();
        Queue<Envelope> queue = this.queuedEnvelopes;
        synchronized (queue) {
            if (this.destroyCalled) {
                Buffer buffer = envelope.getBuffer();
                if (buffer != null) {
                    buffer.recycleBuffer();
                }
                return;
            }
            int expectedSequenceNumber = this.lastReceivedEnvelope + 1;
            if (sequenceNumber != expectedSequenceNumber) {
                Buffer buffer;
                this.reportIOException(new IOException("Expected data packet " + expectedSequenceNumber + " but received " + sequenceNumber));
                this.notifyGateThatInputIsAvailable();
                if (LOG.isErrorEnabled()) {
                    LOG.error("Input channel " + this.toString() + " expected envelope " + expectedSequenceNumber + " but received " + sequenceNumber);
                }
                if ((buffer = envelope.getBuffer()) != null) {
                    buffer.recycleBuffer();
                }
            } else {
                List<? extends AbstractEvent> events;
                this.queuedEnvelopes.add(envelope);
                this.lastReceivedEnvelope = sequenceNumber;
                if (envelope.getBuffer() != null) {
                    this.notifyGateThatInputIsAvailable();
                }
                if ((events = envelope.deserializeEvents()) != null) {
                    for (int i = 0; i < events.size(); ++i) {
                        this.notifyGateThatInputIsAvailable();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ArrayDeque<Buffer> buffersToRecycle = new ArrayDeque<Buffer>();
        Queue<Envelope> queue = this.queuedEnvelopes;
        synchronized (queue) {
            this.destroyCalled = true;
            while (!this.queuedEnvelopes.isEmpty()) {
                Envelope envelope = this.queuedEnvelopes.poll();
                if (envelope.getBuffer() == null) continue;
                buffersToRecycle.add(envelope.getBuffer());
            }
        }
        while (!buffersToRecycle.isEmpty()) {
            ((Buffer)buffersToRecycle.poll()).recycleBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logQueuedEnvelopes() {
        int numberOfQueuedEnvelopes = 0;
        int numberOfQueuedEnvelopesWithMemoryBuffers = 0;
        int numberOfQueuedEnvelopesWithFileBuffers = 0;
        Queue<Envelope> queue = this.queuedEnvelopes;
        synchronized (queue) {
            for (Envelope envelope : this.queuedEnvelopes) {
                ++numberOfQueuedEnvelopes;
                Buffer buffer = envelope.getBuffer();
                if (buffer == null) continue;
                ++numberOfQueuedEnvelopesWithMemoryBuffers;
            }
        }
        System.out.println("\t\t" + this.toString() + ": " + numberOfQueuedEnvelopes + " (" + numberOfQueuedEnvelopesWithMemoryBuffers + ", " + numberOfQueuedEnvelopesWithFileBuffers + ")");
    }

    @Override
    public Buffer requestBuffer(int minBufferSize) throws IOException {
        return this.inputGate.requestBuffer(minBufferSize);
    }

    @Override
    public Buffer requestBufferBlocking(int minBufferSize) throws IOException, InterruptedException {
        return this.inputGate.requestBufferBlocking(minBufferSize);
    }

    @Override
    public int getBufferSize() {
        return this.inputGate.getBufferSize();
    }

    @Override
    public void reportAsynchronousEvent() {
        this.inputGate.reportAsynchronousEvent();
    }

    @Override
    public BufferProvider.BufferAvailabilityRegistration registerBufferAvailabilityListener(BufferAvailabilityListener listener) {
        return this.inputGate.registerBufferAvailabilityListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferOrEvent getNextBufferOrEvent() throws IOException {
        Envelope nextEnvelope;
        if (this.pendingEvents != null) {
            BufferOrEvent next = new BufferOrEvent(this.pendingEvents.next());
            if (!this.pendingEvents.hasNext()) {
                this.pendingEvents = null;
            }
            return next;
        }
        Queue<Envelope> queue = this.queuedEnvelopes;
        synchronized (queue) {
            if (this.queuedEnvelopes.isEmpty()) {
                return null;
            }
            nextEnvelope = this.queuedEnvelopes.poll();
        }
        List<? extends AbstractEvent> events = nextEnvelope.deserializeEvents();
        Iterator<? extends AbstractEvent> eventsIt = events.iterator();
        if (eventsIt.hasNext()) {
            this.pendingEvents = eventsIt;
        }
        if (nextEnvelope.getBuffer() != null) {
            return new BufferOrEvent(nextEnvelope.getBuffer());
        }
        if (this.pendingEvents != null) {
            BufferOrEvent next = new BufferOrEvent(this.pendingEvents.next());
            if (!this.pendingEvents.hasNext()) {
                this.pendingEvents = null;
            }
            return next;
        }
        throw new IOException("Received an envelope with neither data nor events.");
    }

    public void transferEventToOutputChannel(AbstractEvent event) throws IOException, InterruptedException {
        Envelope ephemeralEnvelope = new Envelope(0, this.getJobID(), this.getID());
        ephemeralEnvelope.serializeEventList(Arrays.asList(event));
        this.envelopeDispatcher.dispatchFromInputChannel(ephemeralEnvelope);
    }
}

