/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class RemoteReceiver
implements IOReadableWritable {
    private InetSocketAddress connectionAddress;
    private int connectionIndex;

    public RemoteReceiver(InetSocketAddress connectionAddress, int connectionIndex) {
        if (connectionAddress == null) {
            throw new IllegalArgumentException("Argument connectionAddress must not be null");
        }
        if (connectionIndex < 0) {
            throw new IllegalArgumentException("Argument connectionIndex must be a non-negative integer number");
        }
        this.connectionAddress = connectionAddress;
        this.connectionIndex = connectionIndex;
    }

    public RemoteReceiver() {
        this.connectionAddress = null;
        this.connectionIndex = -1;
    }

    public InetSocketAddress getConnectionAddress() {
        return this.connectionAddress;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    public int hashCode() {
        return this.connectionAddress.hashCode() + 31 * this.connectionIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteReceiver)) {
            return false;
        }
        RemoteReceiver rr = (RemoteReceiver)obj;
        if (!this.connectionAddress.equals(rr.connectionAddress)) {
            return false;
        }
        return this.connectionIndex == rr.connectionIndex;
    }

    public void write(DataOutputView out) throws IOException {
        InetAddress ia = this.connectionAddress.getAddress();
        out.writeInt(ia.getAddress().length);
        out.write(ia.getAddress());
        out.writeInt(this.connectionAddress.getPort());
        out.writeInt(this.connectionIndex);
    }

    public void read(DataInputView in) throws IOException {
        int addr_length = in.readInt();
        byte[] address = new byte[addr_length];
        in.readFully(address);
        InetAddress ia = InetAddress.getByAddress(address);
        int port = in.readInt();
        this.connectionAddress = new InetSocketAddress(ia, port);
        this.connectionIndex = in.readInt();
    }

    public String toString() {
        return this.connectionAddress + " (" + this.connectionIndex + ")";
    }
}

