/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.InstanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceManager {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceManager.class);
    private final Object lock = new Object();
    private final Map<InstanceID, Instance> registeredHostsById;
    private final Map<InstanceConnectionInfo, Instance> registeredHostsByConnection;
    private final Set<InstanceConnectionInfo> deadHosts;
    private final List<InstanceListener> instanceListeners = new ArrayList<InstanceListener>();
    private final long heartbeatTimeout;
    private int totalNumberOfAliveTaskSlots;
    private volatile boolean shutdown;
    private final TimerTask cleanupStaleMachines = new TimerTask(){

        @Override
        public void run() {
            try {
                InstanceManager.this.checkForDeadInstances();
            }
            catch (Throwable t) {
                LOG.error("Checking for dead instances failed.", t);
            }
        }
    };

    public InstanceManager() {
        this(GlobalConfiguration.getLong((String)"jobmanager.max-heartbeat-delay-before-failure.msecs", (long)30000L));
    }

    public InstanceManager(long heartbeatTimeout) {
        this(heartbeatTimeout, heartbeatTimeout);
    }

    public InstanceManager(long heartbeatTimeout, long cleanupInterval) {
        if (heartbeatTimeout <= 0L || cleanupInterval <= 0L) {
            throw new IllegalArgumentException("Heartbeat timeout and cleanup interval must be positive.");
        }
        this.registeredHostsById = new HashMap<InstanceID, Instance>();
        this.registeredHostsByConnection = new HashMap<InstanceConnectionInfo, Instance>();
        this.deadHosts = new HashSet<InstanceConnectionInfo>();
        this.heartbeatTimeout = heartbeatTimeout;
        new Timer(true).schedule(this.cleanupStaleMachines, cleanupInterval, cleanupInterval);
    }

    public long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void killTaskManagers() {
        for (Instance i : this.registeredHostsById.values()) {
            i.stopInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.cleanupStaleMachines.cancel();
            for (Instance i : this.registeredHostsById.values()) {
                i.markDead();
            }
            this.registeredHostsById.clear();
            this.registeredHostsByConnection.clear();
            this.deadHosts.clear();
            this.totalNumberOfAliveTaskSlots = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportHeartBeat(InstanceID instanceId) {
        if (instanceId == null) {
            throw new IllegalArgumentException("InstanceID may not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return false;
            }
            Instance host = this.registeredHostsById.get(instanceId);
            if (host == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received hearbeat from unknown TaskManager with instance ID " + instanceId.toString() + " Possibly TaskManager was maked as dead (timed-out) earlier. " + "Reporting back that task manager is no longer known.");
                }
                return false;
            }
            host.reportHeartBeat();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceID registerTaskManager(InstanceConnectionInfo instanceConnectionInfo, HardwareDescription resources, int numberOfSlots) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("InstanceManager is shut down.");
            }
            Instance prior = this.registeredHostsByConnection.get(instanceConnectionInfo);
            if (prior != null) {
                LOG.error("Registration attempt from TaskManager with connection info " + instanceConnectionInfo + ". This connection is already registered under ID " + prior.getId());
                return null;
            }
            boolean wasDead = this.deadHosts.remove(instanceConnectionInfo);
            if (wasDead) {
                LOG.info("Registering TaskManager with connection info " + instanceConnectionInfo + " which was marked as dead earlier because of a heart-beat timeout.");
            }
            InstanceID id = null;
            while (this.registeredHostsById.containsKey(id = new InstanceID())) {
            }
            Instance host = new Instance(instanceConnectionInfo, id, resources, numberOfSlots);
            this.registeredHostsById.put(id, host);
            this.registeredHostsByConnection.put(instanceConnectionInfo, host);
            this.totalNumberOfAliveTaskSlots += numberOfSlots;
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Registered TaskManager at %s as %s. Current number of registered hosts is %d.", instanceConnectionInfo, id, this.registeredHostsById.size()));
            }
            host.reportHeartBeat();
            this.notifyNewInstance(host);
            return id;
        }
    }

    public int getNumberOfRegisteredTaskManagers() {
        return this.registeredHostsById.size();
    }

    public int getTotalNumberOfSlots() {
        return this.totalNumberOfAliveTaskSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<InstanceID, Instance> getAllRegisteredInstances() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<InstanceID, Instance>(this.registeredHostsById);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener listener) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            this.instanceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener listener) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            this.instanceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewInstance(Instance instance) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            for (InstanceListener listener : this.instanceListeners) {
                try {
                    listener.newInstanceAvailable(instance);
                }
                catch (Throwable t) {
                    LOG.error("Notification of new instance availability failed.", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeadInstance(Instance instance) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            for (InstanceListener listener : this.instanceListeners) {
                try {
                    listener.instanceDied(instance);
                }
                catch (Throwable t) {
                    LOG.error("Notification of dead instance failed.", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForDeadInstances() {
        long now = System.currentTimeMillis();
        long timeout = this.heartbeatTimeout;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Iterator<Map.Entry<InstanceID, Instance>> entries = this.registeredHostsById.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<InstanceID, Instance> entry = entries.next();
                Instance host = entry.getValue();
                if (host.isStillAlive(now, timeout)) continue;
                entries.remove();
                this.registeredHostsByConnection.remove(host.getInstanceConnectionInfo());
                this.deadHosts.add(host.getInstanceConnectionInfo());
                host.markDead();
                this.totalNumberOfAliveTaskSlots -= host.getTotalNumberOfSlots();
                LOG.info(String.format("TaskManager %s at %s did not report a heartbeat for %d msecs - marking as dead. Current number of registered hosts is %d.", host.getId(), host.getInstanceConnectionInfo(), this.heartbeatTimeout, this.registeredHostsById.size()));
                this.notifyDeadInstance(host);
            }
        }
    }
}

