/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.s3;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.s3.S3BucketObjectPair;

public final class S3DirectoryStructure {
    private final String basePath;
    private final Map<Path, S3BucketObjectPair> cache = new HashMap<Path, S3BucketObjectPair>();

    S3DirectoryStructure(String basePath) {
        this.basePath = basePath;
    }

    S3BucketObjectPair toBucketObjectPair(Path path) {
        S3BucketObjectPair bop = this.cache.get(path);
        if (bop != null) {
            return bop;
        }
        URI uri = path.toUri();
        String p = uri.getPath();
        if (!this.basePath.isEmpty() && !p.contains(this.basePath)) {
            throw new IllegalArgumentException(path + " is not a valid path for the file system");
        }
        if (!this.basePath.isEmpty()) {
            int pos = p.indexOf(this.basePath);
            p = p.substring(pos + this.basePath.length());
        }
        if (!p.isEmpty() && p.charAt(0) == '/') {
            p = p.substring(1);
        }
        if (p.isEmpty()) {
            bop = new S3BucketObjectPair(null, null);
            this.cache.put(path, bop);
            return bop;
        }
        int objectPos = p.indexOf(47);
        if (objectPos < 0) {
            bop = new S3BucketObjectPair(p, null);
        } else {
            String bucket = p.substring(0, objectPos);
            String object = p.substring(objectPos + 1);
            bop = object.isEmpty() ? new S3BucketObjectPair(bucket, null) : new S3BucketObjectPair(bucket, object);
        }
        this.cache.put(path, bop);
        return bop;
    }
}

