/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.StringUtils;

public class VertexEvent
extends AbstractEvent {
    private static final long serialVersionUID = -521556020344465262L;
    private JobVertexID jobVertexID;
    private String jobVertexName;
    private int totalNumberOfSubtasks;
    private int indexOfSubtask;
    private ExecutionAttemptID executionAttemptId;
    private ExecutionState currentExecutionState;
    private String description;

    public VertexEvent(long timestamp, JobVertexID jobVertexID, String jobVertexName, int totalNumberOfSubtasks, int indexOfSubtask, ExecutionAttemptID executionAttemptId, ExecutionState currentExecutionState, String description) {
        super(timestamp);
        Preconditions.checkNotNull((Object)jobVertexID);
        Preconditions.checkNotNull((Object)((Object)currentExecutionState));
        this.jobVertexID = jobVertexID;
        this.jobVertexName = jobVertexName;
        this.totalNumberOfSubtasks = totalNumberOfSubtasks;
        this.indexOfSubtask = indexOfSubtask;
        this.executionAttemptId = executionAttemptId;
        this.currentExecutionState = currentExecutionState;
        this.description = description;
    }

    public VertexEvent() {
        this.jobVertexID = new JobVertexID();
        this.totalNumberOfSubtasks = -1;
        this.indexOfSubtask = -1;
        this.executionAttemptId = new ExecutionAttemptID();
        this.currentExecutionState = ExecutionState.CREATED;
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public String getJobVertexName() {
        return this.jobVertexName;
    }

    public int getTotalNumberOfSubtasks() {
        return this.totalNumberOfSubtasks;
    }

    public int getIndexOfSubtask() {
        return this.indexOfSubtask;
    }

    public ExecutionState getCurrentExecutionState() {
        return this.currentExecutionState;
    }

    public String getDescription() {
        return this.description;
    }

    public ExecutionAttemptID getExecutionAttemptId() {
        return this.executionAttemptId;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.jobVertexID.read(in);
        this.executionAttemptId.read(in);
        this.totalNumberOfSubtasks = in.readInt();
        this.indexOfSubtask = in.readInt();
        this.currentExecutionState = ExecutionState.values()[in.readInt()];
        this.jobVertexName = StringUtils.readNullableString((DataInputView)in);
        this.description = StringUtils.readNullableString((DataInputView)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.jobVertexID.write(out);
        this.executionAttemptId.write(out);
        out.writeInt(this.totalNumberOfSubtasks);
        out.writeInt(this.indexOfSubtask);
        out.writeInt(this.currentExecutionState.ordinal());
        StringUtils.writeNullableString((String)this.jobVertexName, (DataOutputView)out);
        StringUtils.writeNullableString((String)this.description, (DataOutputView)out);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VertexEvent) {
            VertexEvent other = (VertexEvent)obj;
            return super.equals(other) && this.jobVertexID.equals(other.jobVertexID) && this.totalNumberOfSubtasks == other.totalNumberOfSubtasks && this.indexOfSubtask == other.indexOfSubtask && this.currentExecutionState == other.currentExecutionState && (this.jobVertexName == null ? other.jobVertexName == null : other.jobVertexName != null && this.jobVertexName.equals(other.jobVertexName)) && (this.description == null ? other.description == null : other.description != null && this.description.equals(other.description));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.jobVertexID.hashCode() ^ 31 * this.indexOfSubtask ^ 17 * this.currentExecutionState.ordinal();
    }

    @Override
    public String toString() {
        return VertexEvent.timestampToString(this.getTimestamp()) + ":\t" + this.jobVertexName + " (" + (this.indexOfSubtask + 1) + "/" + this.totalNumberOfSubtasks + ") switched to " + (Object)((Object)this.currentExecutionState) + (this.description != null ? "\n" + this.description : "");
    }
}

